/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver;

import com.gmail.berndivader.streamserver.config.Config;
import com.gmail.berndivader.streamserver.ffmpeg.FFProbePacket;
import com.gmail.berndivader.streamserver.ffmpeg.InfoPacket;
import com.gmail.berndivader.streamserver.term.ANSI;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public final class Helper {
    public static final ExecutorService EXECUTOR;
    public static final ScheduledExecutorService SCHEDULED_EXECUTOR;
    public static final CloseableHttpClient HTTP_CLIENT;
    public static final Gson LGSON;
    public static final Gson GSON;
    public static File[] files;
    public static File[] customs;

    private Helper() {
    }

    public static int getFilePosition(String name) {
        if (!name.isEmpty()) {
            File[] files = (File[])Helper.files.clone();
            for (int i1 = 0; i1 < files.length; ++i1) {
                String file = files[i1].getName().toLowerCase();
                if (!file.equals(name)) continue;
                return i1;
            }
        }
        return -1;
    }

    public static int getCustomFilePosition(String name) {
        if (!name.isEmpty()) {
            File[] files = (File[])customs.clone();
            for (int i1 = 0; i1 < files.length; ++i1) {
                String file = files[i1].getName().toLowerCase();
                if (!file.equals(name)) continue;
                return i1;
            }
        }
        return -1;
    }

    public static ArrayList<String> getFilelistAsList(String regex) {
        String name;
        int i1;
        regex = ((String)regex).contains("*") ? ((String)regex).replaceAll("*", "(.*)") : "(.*)" + (String)regex + "(.*)";
        ArrayList<String> list = new ArrayList<String>();
        File[] files = (File[])Helper.files.clone();
        for (i1 = 0; i1 < files.length; ++i1) {
            name = files[i1].getName().toLowerCase();
            try {
                if (!name.matches((String)regex)) continue;
                list.add(name);
                continue;
            }
            catch (Exception e) {
                ANSI.printErr("getFilelistAsList method failed.", e);
            }
        }
        files = (File[])customs.clone();
        for (i1 = 0; i1 < files.length; ++i1) {
            name = files[i1].getName().toLowerCase();
            try {
                if (!name.matches((String)regex)) continue;
                list.add(name);
                continue;
            }
            catch (Exception e) {
                ANSI.println(e.getMessage());
            }
        }
        return list;
    }

    public static String getFilelistAsString(String regex) {
        String name;
        int i1;
        int count = 0;
        StringBuilder playlist = new StringBuilder();
        regex = ((String)regex).contains("*") ? ((String)regex).replaceAll("*", "(.*)") : "(.*)" + (String)regex + "(.*)";
        File[] files = (File[])Helper.files.clone();
        for (i1 = 0; i1 < files.length; ++i1) {
            name = files[i1].getName().toLowerCase();
            if (name == null || name.isEmpty() || !name.matches((String)regex)) continue;
            playlist.append(name + "\n");
            ++count;
        }
        files = (File[])customs.clone();
        for (i1 = 0; i1 < files.length; ++i1) {
            name = files[i1].getName().toLowerCase();
            if (name == null || name.isEmpty() || !name.matches((String)regex)) continue;
            playlist.append(name + "\n");
            ++count;
        }
        playlist.append("\nThere are " + count + " matches for " + (String)regex);
        return playlist.toString();
    }

    public static void shuffleFilelist(File[] files) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i1 = files.length - 1; i1 > 0; --i1) {
            int index = ((Random)random).nextInt(i1 + 1);
            File a = files[index];
            files[index] = files[i1];
            files[i1] = a;
        }
    }

    public static void refreshFilelist() {
        File file = new File(Config.PLAYLIST_PATH);
        File custom = new File(Config.PLAYLIST_PATH_CUSTOM);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getAbsolutePath().toLowerCase().endsWith(".mp4");
            }
        };
        files = file.exists() ? (file.isDirectory() ? file.listFiles(filter) : (file.isFile() ? new File[]{file} : new File[0])) : new File[0];
        customs = custom.exists() ? (custom.isDirectory() ? custom.listFiles(filter) : (custom.isFile() ? new File[]{custom} : new File[0])) : new File[0];
    }

    public static String getStringFromStream(InputStream stream, int length) {
        byte[] bytes = new byte[length];
        try {
            int size = stream.read(bytes, 0, length);
            return new String(bytes).substring(0, size - 1);
        }
        catch (IOException e) {
            ANSI.printErr("getStringFromStream method failed.", e);
            return "";
        }
    }

    public static FFProbePacket getProbePacket(File file) {
        FFProbePacket packet = null;
        if (file.exists()) {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.directory(new File("./"));
            builder.command("ffprobe", "-v", "quiet", "-print_format", "json", "-show_format", file.getAbsolutePath());
            try {
                JsonObject o;
                Process process = builder.start();
                InputStream input = process.getInputStream();
                StringBuilder out = new StringBuilder();
                long time = System.currentTimeMillis();
                while (process.isAlive()) {
                    int avail = input.available();
                    if (avail > 0) {
                        out.append(new String(input.readNBytes(avail)));
                    }
                    if (System.currentTimeMillis() - time <= 10000L) continue;
                    ANSI.printWarn("FFProbePacket timeout.");
                    process.destroyForcibly();
                }
                process.inputReader().lines().forEach(line -> out.append((String)line));
                if (!out.isEmpty() && (o = JsonParser.parseString(out.toString()).getAsJsonObject()).has("format")) {
                    packet = LGSON.fromJson(o.get("format"), FFProbePacket.class);
                }
            }
            catch (Exception e) {
                ANSI.printErr("getProbePacket method failed.", e);
            }
        }
        return packet == null ? new FFProbePacket() : packet;
    }

    public static InfoPacket getInfoPacket(String url) {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.directory(new File("./"));
        builder.command("yt-dlp", "--quiet", "--no-warnings", "--dump-json");
        if (Config.YOUTUBE_USE_COOKIES.booleanValue() && Config.YOUTUBE_COOKIES.exists()) {
            builder.command().add("--cookies");
            builder.command().add(Config.YOUTUBE_COOKIES.getAbsolutePath());
        }
        builder.command().add(url);
        InfoPacket info = null;
        try {
            Process process = builder.start();
            InputStream reader = process.getInputStream();
            StringBuilder out = new StringBuilder();
            long start = System.currentTimeMillis();
            while (process.isAlive()) {
                int avail = reader.available();
                if (avail > 0) {
                    out.append(new String(reader.readNBytes(avail)));
                }
                if (System.currentTimeMillis() - start <= 30000L) continue;
                ANSI.printWarn("InfoPacket timeout.");
                process.destroyForcibly();
            }
            if (!out.isEmpty()) {
                info = LGSON.fromJson(out.toString(), InfoPacket.class);
            }
        }
        catch (Exception e) {
            ANSI.printErr("getinfoPacket method failed.", e);
        }
        return info == null ? new InfoPacket() : info;
    }

    public static Map.Entry<ProcessBuilder, Optional<InfoPacket>> prepareDownloadBuilder(File defaultDirectory, String args) {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.directory(defaultDirectory);
        boolean downloadable = args.contains("--link ");
        if (downloadable) {
            args = args.replace("--link", "");
        }
        if (args.contains("--music ")) {
            args = args.replace("--music", "");
            builder.command("yt-dlp", "--progress-delta", "2", "--embed-metadata", "--embed-thumbnail", "--ignore-errors", "--extract-audio", "--format", "bestaudio", "--audio-format", "mp3", "--audio-quality", "160K", "--output", "%(title).64s.%(ext)s", "--restrict-filenames", "--no-playlist");
            dir = Helper.getOrCreateMediaDir(Config.DL_MUSIC_PATH);
            if (dir != null) {
                builder.directory(dir);
            }
        } else if (args.contains("--temp ")) {
            args = args.replace("--temp", "");
            builder.command("yt-dlp", "--progress-delta", "2", "--restrict-filenames", "--embed-metadata", "--embed-thumbnail", "--output", "%(title).64s.%(ext)s");
            dir = Helper.getOrCreateMediaDir(Config.DL_TEMP_PATH);
            if (dir != null) {
                builder.directory(dir);
            }
            downloadable = true;
        } else {
            builder.command("yt-dlp", "--progress-delta", "2", "--restrict-filenames", "--embed-metadata", "--embed-thumbnail", "--output", "%(title).64s.%(ext)s");
            dir = Helper.getOrCreateMediaDir(Config.DL_MEDIA_PATH);
            if (dir != null) {
                builder.directory(dir);
            }
        }
        if (Config.YOUTUBE_USE_COOKIES.booleanValue() && Config.YOUTUBE_COOKIES.exists()) {
            builder.command().add("--cookies");
            builder.command().add(Config.YOUTUBE_COOKIES.getAbsolutePath());
        }
        String[] temp = args.split("--");
        String url = "";
        block8: for (int i = 0; i < temp.length; ++i) {
            String[] parse;
            if (temp[i].isEmpty() || (parse = temp[i].trim().split(" ", 2)).length <= 0) continue;
            switch (parse[0]) {
                case "url": {
                    if (parse.length != 2) continue block8;
                    url = parse[1];
                    parse[1] = "";
                    continue block8;
                }
                case "cookies": {
                    if (Config.YOUTUBE_USE_COOKIES.booleanValue() || !Config.YOUTUBE_COOKIES.exists()) continue block8;
                    builder.command().add("--cookies");
                    builder.command().add(Config.YOUTUBE_COOKIES.getAbsolutePath());
                    continue block8;
                }
                default: {
                    if (parse[0].isEmpty()) continue block8;
                    builder.command().add(parse[0]);
                }
            }
        }
        InfoPacket infoPacket = Helper.getInfoPacket(url);
        if (!url.isEmpty()) {
            builder.command().add(url);
        }
        infoPacket.downloadable = downloadable;
        return Map.entry(builder, Optional.ofNullable(infoPacket));
    }

    public static File getOrCreateMediaDir(String name) {
        File dir = new File(name);
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (dir.isDirectory()) {
            return dir;
        }
        if (Config.DEBUG.booleanValue()) {
            ANSI.printWarn("Failed to create directory: " + name);
        }
        return null;
    }

    public static void close() {
        ANSI.print("[WHITE]Shutdown task executor...");
        EXECUTOR.shutdown();
        ANSI.println("[GREEN]DONE!");
        ANSI.print("[WHITE]Shutdown scheduled task executor...");
        SCHEDULED_EXECUTOR.shutdown();
        ANSI.println("[GREEN]DONE![/GREEN]");
    }

    static {
        files = new File[0];
        customs = new File[0];
        EXECUTOR = Executors.newCachedThreadPool();
        SCHEDULED_EXECUTOR = Executors.newSingleThreadScheduledExecutor();
        HTTP_CLIENT = HttpClients.createMinimal();
        GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        LGSON = new GsonBuilder().setPrettyPrinting().setFieldNamingStrategy(new FieldNamingStrategy(){

            @Override
            public String translateName(Field f) {
                return f.getName().toLowerCase();
            }
        }).disableHtmlEscaping().create();
    }
}

