/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.discord.command.commands;

import com.gmail.berndivader.streamserver.Helper;
import com.gmail.berndivader.streamserver.annotation.DiscordCommand;
import com.gmail.berndivader.streamserver.annotation.Requireds;
import com.gmail.berndivader.streamserver.discord.command.Command;
import com.gmail.berndivader.streamserver.ffmpeg.BroadcastRunner;
import com.gmail.berndivader.streamserver.ffmpeg.FFProbePacket;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.channel.MessageChannel;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.rest.util.Color;
import java.util.function.Consumer;
import reactor.core.publisher.Mono;

@DiscordCommand(name="current", usage="Display current playing file.", requireds={Requireds.BROADCASTRUNNER})
public class Current
extends Command<Message> {
    private FFProbePacket packet = new FFProbePacket();

    @Override
    public Mono<Message> execute(String string, MessageChannel channel) {
        if (BroadcastRunner.currentPlaying != null) {
            this.packet = Helper.getProbePacket(BroadcastRunner.currentPlaying);
        }
        return channel.createEmbed((Consumer<? super EmbedCreateSpec>)new Consumer<EmbedCreateSpec>(){

            @Override
            public void accept(EmbedCreateSpec embed) {
                embed.setColor(Color.CINNABAR);
                if (BroadcastRunner.currentPlaying != null) {
                    embed.setTitle(Current.this.packet.isSet(Current.this.packet.tags.title) ? Current.this.packet.tags.title : "");
                    embed.setAuthor(Current.this.packet.isSet(Current.this.packet.tags.artist) ? Current.this.packet.tags.artist : "", "", "");
                    embed.setDescription(Current.this.packet.isSet(Current.this.packet.tags.description) ? Current.this.packet.tags.description : "");
                    embed.addField("Duration", Current.this.packet.isSet(Current.this.packet.duration) ? Current.this.packet.duration : "", false);
                } else {
                    embed.setDescription("No media streaming.");
                }
            }
        }).doOnError(error -> channel.createEmbed(embed -> {
            embed.setTitle("Error");
            embed.setColor(Color.RED);
            embed.setDescription("Something went wrong while gathering media info.");
        }).subscribe());
    }
}

