/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.Entity;
import discord4j.discordjson.json.StickerData;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class Sticker
implements Entity {
    private final GatewayDiscordClient gateway;
    private final StickerData data;

    public Sticker(GatewayDiscordClient gateway, StickerData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    @Override
    public Snowflake getId() {
        return Snowflake.of(this.data.id());
    }

    public StickerData getData() {
        return this.data;
    }

    public Snowflake getPackId() {
        return Snowflake.of(this.data.packId());
    }

    public String getName() {
        return this.data.name();
    }

    public String getDescription() {
        return this.data.description();
    }

    public List<String> getTags() {
        return this.data.tags().toOptional().map(tags -> tags.split(", ")).map(Arrays::asList).orElse(Collections.emptyList());
    }

    public Format getFormatType() {
        return Format.of(this.data.formatType());
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public static enum Format {
        UNKNOWN(0),
        PNG(1),
        APNG(2),
        LOTTIE(3);

        private final int value;

        private Format(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        private static Format of(int value) {
            switch (value) {
                case 1: {
                    return PNG;
                }
                case 2: {
                    return APNG;
                }
                case 3: {
                    return LOTTIE;
                }
            }
            return UNKNOWN;
        }
    }
}

