/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.PermissionOverwrite;
import discord4j.core.spec.AuditSpec;
import discord4j.discordjson.json.ChannelModifyRequest;
import discord4j.discordjson.json.ImmutableChannelModifyRequest;
import discord4j.discordjson.json.OverwriteData;
import discord4j.discordjson.possible.Possible;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

public class NewsChannelEditSpec
implements AuditSpec<ChannelModifyRequest> {
    private final ImmutableChannelModifyRequest.Builder requestBuilder = ChannelModifyRequest.builder();
    @Nullable
    private String reason;

    public NewsChannelEditSpec setName(String name) {
        this.requestBuilder.name(name);
        return this;
    }

    public NewsChannelEditSpec setPosition(int position) {
        this.requestBuilder.position(position);
        return this;
    }

    public NewsChannelEditSpec setTopic(String topic) {
        this.requestBuilder.topic(topic);
        return this;
    }

    public NewsChannelEditSpec setNsfw(boolean nsfw) {
        this.requestBuilder.nsfw(nsfw);
        return this;
    }

    public NewsChannelEditSpec setPermissionOverwrites(Set<? extends PermissionOverwrite> permissionOverwrites) {
        List<OverwriteData> raw = permissionOverwrites.stream().map(o -> OverwriteData.builder().id(o.getTargetId().asString()).type(o.getType().getValue()).allow(o.getAllowed().getRawValue()).deny(o.getDenied().getRawValue()).build()).collect(Collectors.toList());
        this.requestBuilder.permissionOverwrites(raw);
        return this;
    }

    public NewsChannelEditSpec setParentId(@Nullable Snowflake parentId) {
        this.requestBuilder.parentId(Possible.of(Optional.ofNullable(parentId).map(Snowflake::asString)));
        return this;
    }

    public NewsChannelEditSpec setReason(@Nullable String reason) {
        this.reason = reason;
        return this;
    }

    @Override
    @Nullable
    public String getReason() {
        return this.reason;
    }

    @Override
    public ChannelModifyRequest asRequest() {
        return this.requestBuilder.build();
    }
}

