/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.mysql;

import com.gmail.berndivader.streamserver.Helper;
import com.gmail.berndivader.streamserver.config.Config;
import com.gmail.berndivader.streamserver.ffmpeg.FFProbePacket;
import com.gmail.berndivader.streamserver.mysql.DatabaseConnection;
import com.gmail.berndivader.streamserver.term.ANSI;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class MakeDownloadable
implements Callable<Optional<String>> {
    private static final String INSERT = "INSERT INTO `downloadables` (`uuid`, `path`, timestamp, downloads, temp, `ffprobe`) VALUES(?, ?, ?, ?, ?, ?);";
    private static final String TEST_FOR = "SELECT `uuid` FROM `downloadables` WHERE `path`=?;";
    private static final String UPDATE = "UPDATE `downloadables` SET timestamp=?, `ffprobe`=? WHERE `path`=?;";
    private final File file;
    private final boolean temp;
    public Future<Optional<String>> future;

    public MakeDownloadable(File file, boolean temp) {
        this.temp = temp;
        this.file = file;
        this.future = Helper.EXECUTOR.submit(this);
    }

    @Override
    public Optional<String> call() {
        UUID uuid;
        block30: {
            uuid = UUID.randomUUID();
            FFProbePacket ffprobe = Helper.createProbePacket(this.file);
            boolean exists = false;
            try (Connection connection = DatabaseConnection.getNewConnection();){
                try (PreparedStatement test_for = connection.prepareStatement(TEST_FOR, 1004, 1007);){
                    test_for.setString(1, this.file.getAbsolutePath());
                    ResultSet result = test_for.executeQuery();
                    exists = result.next();
                    if (exists) {
                        uuid = UUID.fromString(result.getString("uuid"));
                    }
                }
                if (exists) {
                    try (PreparedStatement update = connection.prepareStatement(UPDATE, 1004, 1007);){
                        update.setLong(1, System.currentTimeMillis() / 1000L);
                        update.setString(2, ffprobe.toString());
                        update.setString(3, this.file.getAbsolutePath());
                        update.executeUpdate();
                        break block30;
                    }
                }
                try (PreparedStatement insert = connection.prepareStatement(INSERT, 1004, 1007);){
                    insert.setString(1, uuid.toString());
                    insert.setString(2, this.file.getAbsolutePath());
                    insert.setLong(3, System.currentTimeMillis() / 1000L);
                    insert.setInt(4, 0);
                    insert.setBoolean(5, this.temp);
                    insert.setString(6, ffprobe.toString());
                    insert.executeUpdate();
                }
            }
            catch (SQLException e) {
                ANSI.printErr("Failed to create or update downloadable media file.", e);
                return Optional.ofNullable(null);
            }
        }
        File thumbnail = new File(Config.DL_WWW_THUMBNAIL_PATH);
        if (!thumbnail.exists()) {
            thumbnail.mkdirs();
        }
        thumbnail = new File(Config.DL_WWW_THUMBNAIL_PATH, uuid.toString() + ".jpg");
        Helper.extractImageFromMedia(this.file, thumbnail);
        return Optional.of(Config.DL_URL + "/download.php?uuid=" + uuid.toString());
    }
}

