/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain.interaction;

import discord4j.common.annotations.Experimental;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.interaction.ComponentInteractionEvent;
import discord4j.core.object.command.ApplicationCommandInteraction;
import discord4j.core.object.command.Interaction;
import discord4j.core.object.component.ActionRow;
import discord4j.core.object.component.MessageComponent;
import discord4j.core.spec.InteractionPresentModalSpec;
import discord4j.gateway.ShardInfo;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import reactor.core.publisher.Mono;

@Experimental
public class ModalSubmitInteractionEvent
extends ComponentInteractionEvent {
    public ModalSubmitInteractionEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, Interaction interaction) {
        super(gateway, shardInfo, interaction);
    }

    @Override
    public String getCustomId() {
        return (String)this.getInteraction().getCommandInteraction().flatMap(ApplicationCommandInteraction::getCustomId).orElseThrow(IllegalStateException::new);
    }

    public List<MessageComponent> getComponents() {
        return this.getInteraction().getCommandInteraction().map(ApplicationCommandInteraction::getComponents).orElse(Collections.emptyList());
    }

    public <T extends MessageComponent> List<T> getComponents(Class<T> componentType) {
        return this.getComponents().stream().flatMap(it -> {
            if (it instanceof ActionRow) {
                ActionRow row = (ActionRow)it;
                return row.getChildren().stream();
            }
            return Stream.empty();
        }).flatMap(it -> {
            if (componentType.isAssignableFrom(it.getClass())) {
                return Stream.of((MessageComponent)componentType.cast(it));
            }
            return Stream.empty();
        }).collect(Collectors.toList());
    }

    @Override
    public Mono<Void> presentModal(InteractionPresentModalSpec spec) {
        return Mono.error(new UnsupportedOperationException("Modal submit interactions cannot present other modals"));
    }
}

