/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.PermissionOverwrite;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.object.reaction.DefaultReaction;
import discord4j.core.spec.ForumChannelCreateMonoGenerator;
import discord4j.core.spec.ForumTagCreateSpec;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="ForumChannelCreateMonoGenerator", generator="Immutables")
public final class ForumChannelCreateMono
extends ForumChannelCreateMonoGenerator {
    @Nullable
    private final String reason;
    private final String name;
    private final String topic_value;
    private final boolean topic_absent;
    private final Integer rateLimitPerUser_value;
    private final boolean rateLimitPerUser_absent;
    private final Integer position_value;
    private final boolean position_absent;
    private final List<PermissionOverwrite> permissionOverwrites_value;
    private final boolean permissionOverwrites_absent;
    private final Snowflake parentId_value;
    private final boolean parentId_absent;
    private final Boolean nsfw_value;
    private final boolean nsfw_absent;
    private final Integer defaultAutoArchiveDuration_value;
    private final boolean defaultAutoArchiveDuration_absent;
    private final EnumSet<Channel.Flag> flags_value;
    private final boolean flags_absent;
    private final DefaultReaction defaultReactionEmoji_value;
    private final boolean defaultReactionEmoji_absent;
    private final List<ForumTagCreateSpec> availableTags;
    private final Integer defaultSortOrder_value;
    private final boolean defaultSortOrder_absent;
    private final Integer defaultForumLayout_value;
    private final boolean defaultForumLayout_absent;
    private final Guild guild;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ForumChannelCreateMono(String name, Guild guild) {
        this.name = Objects.requireNonNull(name, "name");
        this.guild = Objects.requireNonNull(guild, "guild");
        this.reason = null;
        Possible topic$impl = Possible.absent();
        Possible rateLimitPerUser$impl = Possible.absent();
        Possible position$impl = Possible.absent();
        Possible permissionOverwrites$impl = Possible.absent();
        Possible parentId$impl = Possible.absent();
        Possible nsfw$impl = Possible.absent();
        Possible defaultAutoArchiveDuration$impl = Possible.absent();
        Possible flags$impl = Possible.absent();
        Possible defaultReactionEmoji$impl = Possible.absent();
        this.availableTags = Collections.emptyList();
        Possible defaultSortOrder$impl = Possible.absent();
        Possible defaultForumLayout$impl = Possible.absent();
        this.topic_value = topic$impl.toOptional().orElse(null);
        this.topic_absent = topic$impl.isAbsent();
        this.rateLimitPerUser_value = rateLimitPerUser$impl.toOptional().orElse(null);
        this.rateLimitPerUser_absent = rateLimitPerUser$impl.isAbsent();
        this.position_value = position$impl.toOptional().orElse(null);
        this.position_absent = position$impl.isAbsent();
        this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
        this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
        this.parentId_value = parentId$impl.toOptional().orElse(null);
        this.parentId_absent = parentId$impl.isAbsent();
        this.nsfw_value = nsfw$impl.toOptional().orElse(null);
        this.nsfw_absent = nsfw$impl.isAbsent();
        this.defaultAutoArchiveDuration_value = Possible.flatOpt(defaultAutoArchiveDuration$impl).orElse(null);
        this.defaultAutoArchiveDuration_absent = defaultAutoArchiveDuration$impl.isAbsent();
        this.flags_value = flags$impl.toOptional().orElse(null);
        this.flags_absent = flags$impl.isAbsent();
        this.defaultReactionEmoji_value = Possible.flatOpt(defaultReactionEmoji$impl).orElse(null);
        this.defaultReactionEmoji_absent = defaultReactionEmoji$impl.isAbsent();
        this.defaultSortOrder_value = Possible.flatOpt(defaultSortOrder$impl).orElse(null);
        this.defaultSortOrder_absent = defaultSortOrder$impl.isAbsent();
        this.defaultForumLayout_value = Possible.flatOpt(defaultForumLayout$impl).orElse(null);
        this.defaultForumLayout_absent = defaultForumLayout$impl.isAbsent();
        this.initShim = null;
    }

    private ForumChannelCreateMono(@Nullable String reason, String name, Possible<String> topic, Possible<Integer> rateLimitPerUser, Possible<Integer> position, Possible<List<PermissionOverwrite>> permissionOverwrites, Possible<Snowflake> parentId, Possible<Boolean> nsfw, Possible<Optional<Integer>> defaultAutoArchiveDuration, Possible<EnumSet<Channel.Flag>> flags, Possible<Optional<DefaultReaction>> defaultReactionEmoji, List<ForumTagCreateSpec> availableTags, Possible<Optional<Integer>> defaultSortOrder, Possible<Optional<Integer>> defaultForumLayout, Guild guild) {
        this.reason = reason;
        this.name = name;
        Possible<String> topic$impl = topic;
        Possible<Integer> rateLimitPerUser$impl = rateLimitPerUser;
        Possible<Integer> position$impl = position;
        Possible<List<PermissionOverwrite>> permissionOverwrites$impl = permissionOverwrites;
        Possible<Snowflake> parentId$impl = parentId;
        Possible<Boolean> nsfw$impl = nsfw;
        Possible defaultAutoArchiveDuration$impl = defaultAutoArchiveDuration;
        Possible<EnumSet<Channel.Flag>> flags$impl = flags;
        Possible defaultReactionEmoji$impl = defaultReactionEmoji;
        this.availableTags = availableTags;
        Possible defaultSortOrder$impl = defaultSortOrder;
        Possible defaultForumLayout$impl = defaultForumLayout;
        this.guild = guild;
        this.topic_value = topic$impl.toOptional().orElse(null);
        this.topic_absent = topic$impl.isAbsent();
        this.rateLimitPerUser_value = rateLimitPerUser$impl.toOptional().orElse(null);
        this.rateLimitPerUser_absent = rateLimitPerUser$impl.isAbsent();
        this.position_value = position$impl.toOptional().orElse(null);
        this.position_absent = position$impl.isAbsent();
        this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
        this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
        this.parentId_value = parentId$impl.toOptional().orElse(null);
        this.parentId_absent = parentId$impl.isAbsent();
        this.nsfw_value = nsfw$impl.toOptional().orElse(null);
        this.nsfw_absent = nsfw$impl.isAbsent();
        this.defaultAutoArchiveDuration_value = Possible.flatOpt(defaultAutoArchiveDuration$impl).orElse(null);
        this.defaultAutoArchiveDuration_absent = defaultAutoArchiveDuration$impl.isAbsent();
        this.flags_value = flags$impl.toOptional().orElse(null);
        this.flags_absent = flags$impl.isAbsent();
        this.defaultReactionEmoji_value = Possible.flatOpt(defaultReactionEmoji$impl).orElse(null);
        this.defaultReactionEmoji_absent = defaultReactionEmoji$impl.isAbsent();
        this.defaultSortOrder_value = Possible.flatOpt(defaultSortOrder$impl).orElse(null);
        this.defaultSortOrder_absent = defaultSortOrder$impl.isAbsent();
        this.defaultForumLayout_value = Possible.flatOpt(defaultForumLayout$impl).orElse(null);
        this.defaultForumLayout_absent = defaultForumLayout$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Possible<String> topic() {
        return this.topic_absent ? Possible.absent() : Possible.of(this.topic_value);
    }

    @Override
    public Possible<Integer> rateLimitPerUser() {
        return this.rateLimitPerUser_absent ? Possible.absent() : Possible.of(this.rateLimitPerUser_value);
    }

    @Override
    public Possible<Integer> position() {
        return this.position_absent ? Possible.absent() : Possible.of(this.position_value);
    }

    @Override
    public Possible<List<PermissionOverwrite>> permissionOverwrites() {
        return this.permissionOverwrites_absent ? Possible.absent() : Possible.of(this.permissionOverwrites_value);
    }

    @Override
    public Possible<Snowflake> parentId() {
        return this.parentId_absent ? Possible.absent() : Possible.of(this.parentId_value);
    }

    @Override
    public Possible<Boolean> nsfw() {
        return this.nsfw_absent ? Possible.absent() : Possible.of(this.nsfw_value);
    }

    @Override
    public Possible<Optional<Integer>> defaultAutoArchiveDuration() {
        return this.defaultAutoArchiveDuration_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.defaultAutoArchiveDuration_value));
    }

    @Override
    public Possible<EnumSet<Channel.Flag>> flags() {
        return this.flags_absent ? Possible.absent() : Possible.of(this.flags_value);
    }

    @Override
    public Possible<Optional<DefaultReaction>> defaultReactionEmoji() {
        return this.defaultReactionEmoji_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.defaultReactionEmoji_value));
    }

    @Override
    public List<ForumTagCreateSpec> availableTags() {
        return this.availableTags;
    }

    @Override
    public Possible<Optional<Integer>> defaultSortOrder() {
        return this.defaultSortOrder_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.defaultSortOrder_value));
    }

    @Override
    public Possible<Optional<Integer>> defaultForumLayout() {
        return this.defaultForumLayout_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.defaultForumLayout_value));
    }

    @Override
    public Guild guild() {
        return this.guild;
    }

    public final ForumChannelCreateMono withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new ForumChannelCreateMono(value, this.name, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw(), this.defaultAutoArchiveDuration(), this.flags(), this.defaultReactionEmoji(), this.availableTags, this.defaultSortOrder(), this.defaultForumLayout(), this.guild);
    }

    public final ForumChannelCreateMono withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ForumChannelCreateMono(this.reason, newValue, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw(), this.defaultAutoArchiveDuration(), this.flags(), this.defaultReactionEmoji(), this.availableTags, this.defaultSortOrder(), this.defaultForumLayout(), this.guild);
    }

    public ForumChannelCreateMono withTopic(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ForumChannelCreateMono(this.reason, this.name, newValue, this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw(), this.defaultAutoArchiveDuration(), this.flags(), this.defaultReactionEmoji(), this.availableTags, this.defaultSortOrder(), this.defaultForumLayout(), this.guild);
    }

    public ForumChannelCreateMono withTopic(String value) {
        Possible<String> newValue = Possible.of(value);
        return new ForumChannelCreateMono(this.reason, this.name, newValue, this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw(), this.defaultAutoArchiveDuration(), this.flags(), this.defaultReactionEmoji(), this.availableTags, this.defaultSortOrder(), this.defaultForumLayout(), this.guild);
    }

    public ForumChannelCreateMono withRateLimitPerUser(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new ForumChannelCreateMono(this.reason, this.name, this.topic(), newValue, this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw(), this.defaultAutoArchiveDuration(), this.flags(), this.defaultReactionEmoji(), this.availableTags, this.defaultSortOrder(), this.defaultForumLayout(), this.guild);
    }

    public ForumChannelCreateMono withRateLimitPerUser(Integer value) {
        Possible<Integer> newValue = Possible.of(value);
        return new ForumChannelCreateMono(this.reason, this.name, this.topic(), newValue, this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw(), this.defaultAutoArchiveDuration(), this.flags(), this.defaultReactionEmoji(), this.availableTags, this.defaultSortOrder(), this.defaultForumLayout(), this.guild);
    }

    public ForumChannelCreateMono withPosition(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new ForumChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), newValue, this.permissionOverwrites(), this.parentId(), this.nsfw(), this.defaultAutoArchiveDuration(), this.flags(), this.defaultReactionEmoji(), this.availableTags, this.defaultSortOrder(), this.defaultForumLayout(), this.guild);
    }

    public ForumChannelCreateMono withPosition(Integer value) {
        Possible<Integer> newValue = Possible.of(value);
        return new ForumChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), newValue, this.permissionOverwrites(), this.parentId(), this.nsfw(), this.defaultAutoArchiveDuration(), this.flags(), this.defaultReactionEmoji(), this.availableTags, this.defaultSortOrder(), this.defaultForumLayout(), this.guild);
    }

    public ForumChannelCreateMono withPermissionOverwrites(Possible<? extends List<? extends PermissionOverwrite>> possible) {
        Possible<List<PermissionOverwrite>> newValue = Objects.requireNonNull(possible);
        return new ForumChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), newValue, this.parentId(), this.nsfw(), this.defaultAutoArchiveDuration(), this.flags(), this.defaultReactionEmoji(), this.availableTags, this.defaultSortOrder(), this.defaultForumLayout(), this.guild);
    }

    public ForumChannelCreateMono withPermissionOverwrites(Iterable<? extends PermissionOverwrite> elements) {
        Possible<List<PermissionOverwrite>> newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new ForumChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), newValue, this.parentId(), this.nsfw(), this.defaultAutoArchiveDuration(), this.flags(), this.defaultReactionEmoji(), this.availableTags, this.defaultSortOrder(), this.defaultForumLayout(), this.guild);
    }

    @SafeVarargs
    public final ForumChannelCreateMono withPermissionOverwrites(PermissionOverwrite ... elements) {
        Possible<List<PermissionOverwrite>> newValue = Possible.of(Arrays.asList(elements));
        return new ForumChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), newValue, this.parentId(), this.nsfw(), this.defaultAutoArchiveDuration(), this.flags(), this.defaultReactionEmoji(), this.availableTags, this.defaultSortOrder(), this.defaultForumLayout(), this.guild);
    }

    public ForumChannelCreateMono withParentId(Possible<Snowflake> value) {
        Possible<Snowflake> newValue = Objects.requireNonNull(value);
        return new ForumChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), newValue, this.nsfw(), this.defaultAutoArchiveDuration(), this.flags(), this.defaultReactionEmoji(), this.availableTags, this.defaultSortOrder(), this.defaultForumLayout(), this.guild);
    }

    public ForumChannelCreateMono withParentId(Snowflake value) {
        Possible<Snowflake> newValue = Possible.of(value);
        return new ForumChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), newValue, this.nsfw(), this.defaultAutoArchiveDuration(), this.flags(), this.defaultReactionEmoji(), this.availableTags, this.defaultSortOrder(), this.defaultForumLayout(), this.guild);
    }

    public ForumChannelCreateMono withNsfw(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new ForumChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), newValue, this.defaultAutoArchiveDuration(), this.flags(), this.defaultReactionEmoji(), this.availableTags, this.defaultSortOrder(), this.defaultForumLayout(), this.guild);
    }

    public ForumChannelCreateMono withNsfw(Boolean value) {
        Possible<Boolean> newValue = Possible.of(value);
        return new ForumChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), newValue, this.defaultAutoArchiveDuration(), this.flags(), this.defaultReactionEmoji(), this.availableTags, this.defaultSortOrder(), this.defaultForumLayout(), this.guild);
    }

    public ForumChannelCreateMono withDefaultAutoArchiveDuration(Possible<Optional<Integer>> value) {
        Possible<Optional<Integer>> newValue = Objects.requireNonNull(value);
        return new ForumChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw(), newValue, this.flags(), this.defaultReactionEmoji(), this.availableTags, this.defaultSortOrder(), this.defaultForumLayout(), this.guild);
    }

    @Deprecated
    public ForumChannelCreateMono withDefaultAutoArchiveDuration(@Nullable Integer value) {
        Possible<Optional<Integer>> newValue = Possible.of(Optional.ofNullable(value));
        return new ForumChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw(), newValue, this.flags(), this.defaultReactionEmoji(), this.availableTags, this.defaultSortOrder(), this.defaultForumLayout(), this.guild);
    }

    public ForumChannelCreateMono withDefaultAutoArchiveDurationOrNull(@Nullable Integer value) {
        Possible<Optional<Integer>> newValue = Possible.of(Optional.ofNullable(value));
        return new ForumChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw(), newValue, this.flags(), this.defaultReactionEmoji(), this.availableTags, this.defaultSortOrder(), this.defaultForumLayout(), this.guild);
    }

    public ForumChannelCreateMono withFlags(Possible<EnumSet<Channel.Flag>> value) {
        Possible<EnumSet<Channel.Flag>> newValue = Objects.requireNonNull(value);
        return new ForumChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw(), this.defaultAutoArchiveDuration(), newValue, this.defaultReactionEmoji(), this.availableTags, this.defaultSortOrder(), this.defaultForumLayout(), this.guild);
    }

    public ForumChannelCreateMono withFlags(EnumSet<Channel.Flag> value) {
        Possible<EnumSet<Channel.Flag>> newValue = Possible.of(value);
        return new ForumChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw(), this.defaultAutoArchiveDuration(), newValue, this.defaultReactionEmoji(), this.availableTags, this.defaultSortOrder(), this.defaultForumLayout(), this.guild);
    }

    public ForumChannelCreateMono withDefaultReactionEmoji(Possible<Optional<DefaultReaction>> value) {
        Possible<Optional<DefaultReaction>> newValue = Objects.requireNonNull(value);
        return new ForumChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw(), this.defaultAutoArchiveDuration(), this.flags(), newValue, this.availableTags, this.defaultSortOrder(), this.defaultForumLayout(), this.guild);
    }

    @Deprecated
    public ForumChannelCreateMono withDefaultReactionEmoji(@Nullable DefaultReaction value) {
        Possible<Optional<DefaultReaction>> newValue = Possible.of(Optional.ofNullable(value));
        return new ForumChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw(), this.defaultAutoArchiveDuration(), this.flags(), newValue, this.availableTags, this.defaultSortOrder(), this.defaultForumLayout(), this.guild);
    }

    public ForumChannelCreateMono withDefaultReactionEmojiOrNull(@Nullable DefaultReaction value) {
        Possible<Optional<DefaultReaction>> newValue = Possible.of(Optional.ofNullable(value));
        return new ForumChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw(), this.defaultAutoArchiveDuration(), this.flags(), newValue, this.availableTags, this.defaultSortOrder(), this.defaultForumLayout(), this.guild);
    }

    public final ForumChannelCreateMono withAvailableTags(ForumTagCreateSpec ... elements) {
        List<ForumTagCreateSpec> newValue = ForumChannelCreateMono.createUnmodifiableList(false, ForumChannelCreateMono.createSafeList(Arrays.asList(elements), true, false));
        return new ForumChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw(), this.defaultAutoArchiveDuration(), this.flags(), this.defaultReactionEmoji(), newValue, this.defaultSortOrder(), this.defaultForumLayout(), this.guild);
    }

    public final ForumChannelCreateMono withAvailableTags(Iterable<? extends ForumTagCreateSpec> elements) {
        if (this.availableTags == elements) {
            return this;
        }
        List<ForumTagCreateSpec> newValue = ForumChannelCreateMono.createUnmodifiableList(false, ForumChannelCreateMono.createSafeList(elements, true, false));
        return new ForumChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw(), this.defaultAutoArchiveDuration(), this.flags(), this.defaultReactionEmoji(), newValue, this.defaultSortOrder(), this.defaultForumLayout(), this.guild);
    }

    public ForumChannelCreateMono withDefaultSortOrder(Possible<Optional<Integer>> value) {
        Possible<Optional<Integer>> newValue = Objects.requireNonNull(value);
        return new ForumChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw(), this.defaultAutoArchiveDuration(), this.flags(), this.defaultReactionEmoji(), this.availableTags, newValue, this.defaultForumLayout(), this.guild);
    }

    @Deprecated
    public ForumChannelCreateMono withDefaultSortOrder(@Nullable Integer value) {
        Possible<Optional<Integer>> newValue = Possible.of(Optional.ofNullable(value));
        return new ForumChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw(), this.defaultAutoArchiveDuration(), this.flags(), this.defaultReactionEmoji(), this.availableTags, newValue, this.defaultForumLayout(), this.guild);
    }

    public ForumChannelCreateMono withDefaultSortOrderOrNull(@Nullable Integer value) {
        Possible<Optional<Integer>> newValue = Possible.of(Optional.ofNullable(value));
        return new ForumChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw(), this.defaultAutoArchiveDuration(), this.flags(), this.defaultReactionEmoji(), this.availableTags, newValue, this.defaultForumLayout(), this.guild);
    }

    public ForumChannelCreateMono withDefaultForumLayout(Possible<Optional<Integer>> value) {
        Possible<Optional<Integer>> newValue = Objects.requireNonNull(value);
        return new ForumChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw(), this.defaultAutoArchiveDuration(), this.flags(), this.defaultReactionEmoji(), this.availableTags, this.defaultSortOrder(), newValue, this.guild);
    }

    @Deprecated
    public ForumChannelCreateMono withDefaultForumLayout(@Nullable Integer value) {
        Possible<Optional<Integer>> newValue = Possible.of(Optional.ofNullable(value));
        return new ForumChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw(), this.defaultAutoArchiveDuration(), this.flags(), this.defaultReactionEmoji(), this.availableTags, this.defaultSortOrder(), newValue, this.guild);
    }

    public ForumChannelCreateMono withDefaultForumLayoutOrNull(@Nullable Integer value) {
        Possible<Optional<Integer>> newValue = Possible.of(Optional.ofNullable(value));
        return new ForumChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw(), this.defaultAutoArchiveDuration(), this.flags(), this.defaultReactionEmoji(), this.availableTags, this.defaultSortOrder(), newValue, this.guild);
    }

    public final ForumChannelCreateMono withGuild(Guild value) {
        if (this.guild == value) {
            return this;
        }
        Guild newValue = Objects.requireNonNull(value, "guild");
        return new ForumChannelCreateMono(this.reason, this.name, this.topic(), this.rateLimitPerUser(), this.position(), this.permissionOverwrites(), this.parentId(), this.nsfw(), this.defaultAutoArchiveDuration(), this.flags(), this.defaultReactionEmoji(), this.availableTags, this.defaultSortOrder(), this.defaultForumLayout(), newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ForumChannelCreateMono && this.equalTo(0, (ForumChannelCreateMono)another);
    }

    private boolean equalTo(int synthetic, ForumChannelCreateMono another) {
        return Objects.equals(this.reason, another.reason) && this.name.equals(another.name) && this.topic().equals(another.topic()) && this.rateLimitPerUser().equals(another.rateLimitPerUser()) && this.position().equals(another.position()) && Objects.equals(this.permissionOverwrites_value, another.permissionOverwrites_value) && this.parentId().equals(another.parentId()) && this.nsfw().equals(another.nsfw()) && this.defaultAutoArchiveDuration().equals(another.defaultAutoArchiveDuration()) && this.flags().equals(another.flags()) && this.defaultReactionEmoji().equals(another.defaultReactionEmoji()) && this.availableTags.equals(another.availableTags) && this.defaultSortOrder().equals(another.defaultSortOrder()) && this.defaultForumLayout().equals(another.defaultForumLayout()) && this.guild.equals(another.guild);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.reason);
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + this.topic().hashCode();
        h2 += (h2 << 5) + this.rateLimitPerUser().hashCode();
        h2 += (h2 << 5) + this.position().hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.permissionOverwrites_value);
        h2 += (h2 << 5) + this.parentId().hashCode();
        h2 += (h2 << 5) + this.nsfw().hashCode();
        h2 += (h2 << 5) + this.defaultAutoArchiveDuration().hashCode();
        h2 += (h2 << 5) + this.flags().hashCode();
        h2 += (h2 << 5) + this.defaultReactionEmoji().hashCode();
        h2 += (h2 << 5) + this.availableTags.hashCode();
        h2 += (h2 << 5) + this.defaultSortOrder().hashCode();
        h2 += (h2 << 5) + this.defaultForumLayout().hashCode();
        h2 += (h2 << 5) + this.guild.hashCode();
        return h2;
    }

    public static ForumChannelCreateMono of(String name, Guild guild) {
        return new ForumChannelCreateMono(name, guild);
    }

    static ForumChannelCreateMono copyOf(ForumChannelCreateMonoGenerator instance) {
        if (instance instanceof ForumChannelCreateMono) {
            return (ForumChannelCreateMono)instance;
        }
        return ForumChannelCreateMono.of(instance.name(), instance.guild()).withReason(instance.reason()).withTopic(instance.topic()).withRateLimitPerUser(instance.rateLimitPerUser()).withPosition(instance.position()).withPermissionOverwrites(instance.permissionOverwrites()).withParentId(instance.parentId()).withNsfw(instance.nsfw()).withDefaultAutoArchiveDuration(instance.defaultAutoArchiveDuration()).withFlags(instance.flags()).withDefaultReactionEmoji(instance.defaultReactionEmoji()).withAvailableTags(instance.availableTags()).withDefaultSortOrder(instance.defaultSortOrder()).withDefaultForumLayout(instance.defaultForumLayout());
    }

    public boolean isTopicPresent() {
        return !this.topic_absent;
    }

    public String topicOrElse(String defaultValue) {
        return !this.topic_absent ? this.topic_value : defaultValue;
    }

    public boolean isRateLimitPerUserPresent() {
        return !this.rateLimitPerUser_absent;
    }

    public Integer rateLimitPerUserOrElse(Integer defaultValue) {
        return !this.rateLimitPerUser_absent ? this.rateLimitPerUser_value : defaultValue;
    }

    public boolean isPositionPresent() {
        return !this.position_absent;
    }

    public Integer positionOrElse(Integer defaultValue) {
        return !this.position_absent ? this.position_value : defaultValue;
    }

    public boolean isPermissionOverwritesPresent() {
        return !this.permissionOverwrites_absent;
    }

    public List<PermissionOverwrite> permissionOverwritesOrElse(List<PermissionOverwrite> defaultValue) {
        return !this.permissionOverwrites_absent ? this.permissionOverwrites_value : defaultValue;
    }

    public boolean isParentIdPresent() {
        return !this.parentId_absent;
    }

    public Snowflake parentIdOrElse(Snowflake defaultValue) {
        return !this.parentId_absent ? this.parentId_value : defaultValue;
    }

    public boolean isNsfwPresent() {
        return !this.nsfw_absent;
    }

    public Boolean nsfwOrElse(Boolean defaultValue) {
        return !this.nsfw_absent ? this.nsfw_value : defaultValue;
    }

    public boolean isDefaultAutoArchiveDurationPresent() {
        return !this.defaultAutoArchiveDuration_absent;
    }

    public Integer defaultAutoArchiveDurationOrElse(Integer defaultValue) {
        return !this.defaultAutoArchiveDuration_absent ? this.defaultAutoArchiveDuration_value : defaultValue;
    }

    public boolean isFlagsPresent() {
        return !this.flags_absent;
    }

    public EnumSet<Channel.Flag> flagsOrElse(EnumSet<Channel.Flag> defaultValue) {
        return !this.flags_absent ? this.flags_value : defaultValue;
    }

    public boolean isDefaultReactionEmojiPresent() {
        return !this.defaultReactionEmoji_absent;
    }

    public DefaultReaction defaultReactionEmojiOrElse(DefaultReaction defaultValue) {
        return !this.defaultReactionEmoji_absent ? this.defaultReactionEmoji_value : defaultValue;
    }

    public boolean isDefaultSortOrderPresent() {
        return !this.defaultSortOrder_absent;
    }

    public Integer defaultSortOrderOrElse(Integer defaultValue) {
        return !this.defaultSortOrder_absent ? this.defaultSortOrder_value : defaultValue;
    }

    public boolean isDefaultForumLayoutPresent() {
        return !this.defaultForumLayout_absent;
    }

    public Integer defaultForumLayoutOrElse(Integer defaultValue) {
        return !this.defaultForumLayout_absent ? this.defaultForumLayout_value : defaultValue;
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ForumChannelCreateMonoGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build ForumChannelCreateMono, attribute initializers form cycle " + attributes;
        }
    }
}

