/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.config;

import com.gmail.berndivader.streamserver.Helper;
import com.gmail.berndivader.streamserver.StreamServer;
import com.gmail.berndivader.streamserver.config.ConfigData;
import com.gmail.berndivader.streamserver.term.ANSI;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URISyntaxException;
import java.util.Scanner;

public class Config {
    public static String STREAM_KEY = "xxxx-xxxx-xxxx-xxxx-xxxx";
    public static String STREAM_URL = "rtmp://a.rtmp.youtube.com/live2";
    public static String YOUTUBE_LINK = "https://youtu.be/xxxxxxx";
    public static String YOUTUBE_KEY = "yt-api-key";
    public static String YOUTUBE_CHANNEL_ID = "yt-channel-id";
    public static Boolean YOUTUBE_USE_COOKIES = false;
    public static File YOUTUBE_COOKIES;
    public static Boolean STREAM_BOT_START;
    public static Boolean DISCORD_BOT_START;
    public static String PLAYLIST_PATH;
    public static String PLAYLIST_PATH_CUSTOM;
    public static String DL_ROOT_PATH;
    private static String DL_MUSIC_PATH;
    private static String DL_TEMP_PATH;
    private static String DL_MEDIA_PATH;
    public static String DL_WWW_THUMBNAIL_PATH;
    public static Long DL_TIMEOUT_SECONDS;
    public static String DL_URL;
    public static String DL_INTERVAL_FORMAT;
    public static Integer DL_INTERVAL_VALUE;
    public static String DATABASE_PREFIX;
    public static String DATABASE_HOST;
    public static String DATABASE_PORT;
    public static String DATABASE_NAME;
    public static String DATABASE_USER;
    public static String DATABASE_PWD;
    public static String DISCORD_TOKEN;
    public static String DISCORD_CHANNEL;
    public static Long DISCORD_ROLE_ID;
    @Deprecated
    public static String DISCORD_ROLE;
    public static String DISCORD_COMMAND_PREFIX;
    public static Boolean DISCORD_RESPONSE_TO_PRIVATE;
    public static String HELP_TEXT;
    public static String DISCORD_HELP_TEXT;
    public static Boolean DEBUG;
    public static String working_dir;
    public static File config_dir;
    public static File config_file;
    public static ConfigData data;
    public static Config instance;

    public Config() {
        ANSI.println("[WHITE]Load or create config...");
        if (Config.loadConfig()) {
            ANSI.println("[GREEN]DONE![/GREEN]");
            Config.saveConfig();
        } else {
            ANSI.printWarn("Failed loading or creating config file. Using default values.");
        }
    }

    private static void createDefault() {
        config_dir.mkdir();
        data = new ConfigData();
        Config.saveConfig();
    }

    public static boolean saveConfig() {
        boolean ok = true;
        try (FileWriter writer = new FileWriter(config_file.getAbsoluteFile());){
            Config.data.PLAYLIST_PATH = PLAYLIST_PATH;
            Config.data.PLAYLIST_PATH_CUSTOM = PLAYLIST_PATH_CUSTOM;
            Config.data.DL_ROOT_PATH = DL_ROOT_PATH;
            Config.data.DL_MUSIC_PATH = DL_MUSIC_PATH;
            Config.data.DL_TEMP_PATH = DL_TEMP_PATH;
            Config.data.DL_MEDIA_PATH = DL_MEDIA_PATH;
            Config.data.DL_WWW_THUMBNAIL_PATH = DL_WWW_THUMBNAIL_PATH;
            Config.data.DL_TIMEOUT_SECONDS = DL_TIMEOUT_SECONDS;
            Config.data.DL_URL = DL_URL;
            Config.data.DL_INTERVAL_FORMAT = DL_INTERVAL_FORMAT;
            Config.data.DL_INTERVAL_VALUE = DL_INTERVAL_VALUE;
            Config.data.STREAM_KEY = STREAM_KEY;
            Config.data.STREAM_URL = STREAM_URL;
            Config.data.YOUTUBE_LINK = YOUTUBE_LINK;
            Config.data.YOUTUBE_KEY = YOUTUBE_KEY;
            Config.data.YOUTUBE_USE_COOKIES = YOUTUBE_USE_COOKIES;
            Config.data.YOUTUBE_CHANNEL_ID = YOUTUBE_CHANNEL_ID;
            Config.data.STREAM_BOT_START = STREAM_BOT_START;
            Config.data.DATABASE_HOST = DATABASE_HOST;
            Config.data.DATABASE_PORT = DATABASE_PORT;
            Config.data.DATABASE_NAME = DATABASE_NAME;
            Config.data.DATABASE_USER = DATABASE_USER;
            Config.data.DATABASE_PWD = DATABASE_PWD;
            Config.data.DISCORD_TOKEN = DISCORD_TOKEN;
            Config.data.DISCORD_CHANNEL = DISCORD_CHANNEL;
            Config.data.DISCORD_ROLE = DISCORD_ROLE;
            Config.data.DISCORD_ROLE_ID = DISCORD_ROLE_ID;
            Config.data.DISCORD_COMMAND_PREFIX = DISCORD_COMMAND_PREFIX;
            Config.data.DISCORD_RESPONSE_TO_PRIVATE = DISCORD_RESPONSE_TO_PRIVATE;
            Config.data.DISCORD_BOT_START = DISCORD_BOT_START;
            Helper.GSON.toJson((Object)data, (Appendable)writer);
        }
        catch (IOException e) {
            ok = false;
            ANSI.printErr("Error while saving config file.", e);
        }
        return ok;
    }

    public static boolean loadConfig() {
        try (FileReader reader = new FileReader(config_file.getAbsoluteFile());){
            data = Helper.GSON.fromJson((Reader)reader, ConfigData.class);
            if (Config.data.PLAYLIST_PATH != null) {
                PLAYLIST_PATH = Config.data.PLAYLIST_PATH;
            }
            if (Config.data.PLAYLIST_PATH_CUSTOM != null) {
                PLAYLIST_PATH_CUSTOM = Config.data.PLAYLIST_PATH_CUSTOM;
            }
            if (Config.data.DL_ROOT_PATH != null) {
                DL_ROOT_PATH = Config.data.DL_ROOT_PATH;
            }
            if (Config.data.DL_MUSIC_PATH != null) {
                DL_MUSIC_PATH = Config.data.DL_MUSIC_PATH;
            }
            if (Config.data.DL_TEMP_PATH != null) {
                DL_TEMP_PATH = Config.data.DL_TEMP_PATH;
            }
            if (Config.data.DL_MEDIA_PATH != null) {
                DL_MEDIA_PATH = Config.data.DL_MEDIA_PATH;
            }
            if (Config.data.DL_WWW_THUMBNAIL_PATH != null) {
                DL_WWW_THUMBNAIL_PATH = Config.data.DL_WWW_THUMBNAIL_PATH;
            }
            if (Config.data.DL_TIMEOUT_SECONDS != null) {
                DL_TIMEOUT_SECONDS = Config.data.DL_TIMEOUT_SECONDS;
            }
            if (Config.data.DL_URL != null) {
                DL_URL = Config.data.DL_URL;
            }
            if (Config.data.DL_INTERVAL_FORMAT != null) {
                DL_INTERVAL_FORMAT = Config.data.DL_INTERVAL_FORMAT;
            }
            if (Config.data.DL_INTERVAL_VALUE != null) {
                DL_INTERVAL_VALUE = Config.data.DL_INTERVAL_VALUE;
            }
            if (Config.data.STREAM_KEY != null) {
                STREAM_KEY = Config.data.STREAM_KEY;
            }
            if (Config.data.STREAM_URL != null) {
                STREAM_URL = Config.data.STREAM_URL;
            }
            if (Config.data.YOUTUBE_LINK != null) {
                YOUTUBE_LINK = Config.data.YOUTUBE_LINK;
            }
            if (Config.data.YOUTUBE_KEY != null) {
                YOUTUBE_KEY = Config.data.YOUTUBE_KEY;
            }
            if (Config.data.YOUTUBE_USE_COOKIES != null) {
                YOUTUBE_USE_COOKIES = Config.data.YOUTUBE_USE_COOKIES;
            }
            if (Config.data.YOUTUBE_CHANNEL_ID != null) {
                YOUTUBE_CHANNEL_ID = Config.data.YOUTUBE_CHANNEL_ID;
            }
            if (Config.data.STREAM_BOT_START != null) {
                STREAM_BOT_START = Config.data.STREAM_BOT_START;
            }
            if (Config.data.DATABASE_HOST != null) {
                DATABASE_HOST = Config.data.DATABASE_HOST;
            }
            if (Config.data.DATABASE_PORT != null) {
                DATABASE_PORT = Config.data.DATABASE_PORT;
            }
            if (Config.data.DATABASE_NAME != null) {
                DATABASE_NAME = Config.data.DATABASE_NAME;
            }
            if (Config.data.DATABASE_USER != null) {
                DATABASE_USER = Config.data.DATABASE_USER;
            }
            if (Config.data.DATABASE_PWD != null) {
                DATABASE_PWD = Config.data.DATABASE_PWD;
            }
            if (Config.data.DISCORD_TOKEN != null) {
                DISCORD_TOKEN = Config.data.DISCORD_TOKEN;
            }
            if (Config.data.DISCORD_CHANNEL != null) {
                DISCORD_CHANNEL = Config.data.DISCORD_CHANNEL;
            }
            if (Config.data.DISCORD_ROLE != null) {
                DISCORD_ROLE = Config.data.DISCORD_ROLE;
            }
            if (Config.data.DISCORD_ROLE_ID != null) {
                DISCORD_ROLE_ID = Config.data.DISCORD_ROLE_ID;
            }
            if (Config.data.DISCORD_COMMAND_PREFIX != null) {
                DISCORD_COMMAND_PREFIX = Config.data.DISCORD_COMMAND_PREFIX;
            }
            if (Config.data.DISCORD_RESPONSE_TO_PRIVATE != null) {
                DISCORD_RESPONSE_TO_PRIVATE = Config.data.DISCORD_RESPONSE_TO_PRIVATE;
            }
            if (Config.data.DISCORD_BOT_START != null) {
                DISCORD_BOT_START = Config.data.DISCORD_BOT_START;
            }
        }
        catch (IOException e) {
            ANSI.printErr("Error while loading config file.", e);
            return false;
        }
        return true;
    }

    public static String musicPath() {
        return DL_ROOT_PATH + DL_MUSIC_PATH;
    }

    public static String mediaPath() {
        return DL_ROOT_PATH + DL_MEDIA_PATH;
    }

    public static String tempPath() {
        return DL_ROOT_PATH + DL_TEMP_PATH;
    }

    public static String connectionString() {
        return DATABASE_PREFIX + DATABASE_HOST + ":" + DATABASE_PORT + "/" + DATABASE_NAME;
    }

    private static String inputstreamToString(InputStream is) {
        String output = null;
        try (Scanner s2 = new Scanner(is);){
            s2.useDelimiter("\\A");
            output = s2.hasNext() ? s2.next() : "";
            try {
                is.close();
            }
            catch (IOException e1) {
                ANSI.printErr("Error while reading from an InputStream", e1);
            }
        }
        return output;
    }

    static {
        STREAM_BOT_START = true;
        DISCORD_BOT_START = true;
        PLAYLIST_PATH = "./playlist";
        PLAYLIST_PATH_CUSTOM = "./custom";
        DL_ROOT_PATH = "./library";
        DL_MUSIC_PATH = "/music";
        DL_TEMP_PATH = "/temp";
        DL_MEDIA_PATH = "/media";
        DL_WWW_THUMBNAIL_PATH = "/absolute/path/to/thumbnails";
        DL_TIMEOUT_SECONDS = 1800L;
        DL_URL = "https://path.to.php";
        DL_INTERVAL_FORMAT = "DAY";
        DL_INTERVAL_VALUE = 14;
        DATABASE_PREFIX = "jdbc:mysql://";
        DATABASE_HOST = "x.x.xxx.xxx";
        DATABASE_PORT = "3306";
        DATABASE_NAME = "ytbot";
        DATABASE_USER = "default";
        DATABASE_PWD = "default";
        DISCORD_TOKEN = "default";
        DISCORD_CHANNEL = "Mett TV";
        DISCORD_ROLE_ID = 0L;
        DISCORD_ROLE = "Deprecated";
        DISCORD_COMMAND_PREFIX = ".mtv";
        DISCORD_RESPONSE_TO_PRIVATE = true;
        DEBUG = false;
        try {
            HELP_TEXT = Config.inputstreamToString(StreamServer.class.getResourceAsStream("/help.txt"));
            DISCORD_HELP_TEXT = Config.inputstreamToString(StreamServer.class.getResourceAsStream("/discord_help.txt"));
            working_dir = new File(StreamServer.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParent();
        }
        catch (URISyntaxException ex) {
            ANSI.printErr("URISyntaxException", ex);
        }
        config_dir = new File(working_dir, "config");
        config_file = new File(config_dir, "config.json");
        if (!config_dir.exists()) {
            config_dir.mkdir();
            Config.createDefault();
        }
        if (!config_file.exists()) {
            Config.createDefault();
        }
        YOUTUBE_COOKIES = new File(config_dir, "cookies.txt");
    }
}

