/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.entity;

import discord4j.common.util.Snowflake;
import discord4j.discordjson.json.StageInstanceData;
import discord4j.discordjson.json.StageInstanceModifyRequest;
import discord4j.rest.RestClient;
import java.util.Objects;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class RestStageInstance {
    private final RestClient restClient;
    private final long channelId;

    private RestStageInstance(RestClient restClient, long channelId) {
        this.restClient = restClient;
        this.channelId = channelId;
    }

    public static RestStageInstance create(RestClient restClient, Snowflake channelId) {
        return new RestStageInstance(restClient, channelId.asLong());
    }

    static RestStageInstance create(RestClient restClient, long channelId) {
        return new RestStageInstance(restClient, channelId);
    }

    public Snowflake getChannelId() {
        return Snowflake.of(this.channelId);
    }

    public Mono<StageInstanceData> getData() {
        return this.restClient.getStageInstanceService().getStageInstance(this.channelId);
    }

    public Mono<StageInstanceData> edit(StageInstanceModifyRequest request, @Nullable String reason) {
        return this.restClient.getStageInstanceService().modifyStageInstance(this.channelId, request, reason);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestStageInstance that = (RestStageInstance)o;
        return this.channelId == that.channelId;
    }

    public int hashCode() {
        return Objects.hash(this.channelId);
    }
}

