/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.util;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;

public class Multimap<K, V>
implements Map<K, List<V>> {
    private final Map<K, List<V>> map;

    public Multimap() {
        this.map = new LinkedHashMap<K, List<V>>();
    }

    public Multimap(int initialCapacity) {
        this.map = new LinkedHashMap<K, List<V>>(initialCapacity);
    }

    public void add(K key, V value) {
        this.map.computeIfAbsent(key, k -> new LinkedList()).add(value);
    }

    public void addAll(K key, Collection<? extends V> values) {
        this.map.computeIfAbsent(key, k -> new LinkedList()).addAll(values);
    }

    public void addAll(Multimap<K, V> values) {
        values.forEach(this::addAll);
    }

    public void set(K key, V value) {
        LinkedList<V> list = new LinkedList<V>();
        list.add(value);
        this.map.put(key, list);
    }

    public void setAll(Map<K, V> values) {
        values.forEach(this::set);
    }

    public Multimap<K, V> deepCopy() {
        Multimap copy = new Multimap(this.map.size());
        this.map.forEach((key, value) -> copy.put((K)key, new LinkedList(value)));
        return copy;
    }

    public void forEachElement(BiConsumer<? super K, ? super V> action) {
        Objects.requireNonNull(action);
        for (Map.Entry<K, List<V>> entry : this.entrySet()) {
            try {
                for (V v : entry.getValue()) {
                    K k = entry.getKey();
                    action.accept(k, v);
                }
            }
            catch (IllegalStateException ise) {
                throw new ConcurrentModificationException(ise);
            }
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public List<V> get(Object key) {
        return this.map.get(key);
    }

    @Override
    public List<V> put(K key, List<V> value) {
        return this.map.put(key, value);
    }

    @Override
    public List<V> remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends List<V>> m3) {
        this.map.putAll(m3);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<List<V>> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.map.entrySet();
    }
}

