/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain.interaction;

import discord4j.common.annotations.Experimental;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.interaction.ApplicationCommandInteractionEvent;
import discord4j.core.object.command.ApplicationCommandInteraction;
import discord4j.core.object.command.Interaction;
import discord4j.core.object.entity.Message;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.gateway.ShardInfo;
import reactor.core.publisher.Mono;

@Experimental
public class MessageInteractionEvent
extends ApplicationCommandInteractionEvent {
    public MessageInteractionEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, Interaction interaction) {
        super(gateway, shardInfo, interaction);
    }

    public Message getResolvedMessage() {
        return (Message)this.getInteraction().getCommandInteraction().flatMap(ApplicationCommandInteraction::getResolved).flatMap(it -> it.getMessage(this.getTargetId())).orElseThrow(IllegalStateException::new);
    }

    public Snowflake getTargetId() {
        return (Snowflake)this.getInteraction().getCommandInteraction().flatMap(ApplicationCommandInteraction::getTargetId).orElseThrow(IllegalStateException::new);
    }

    public Mono<Message> getTargetMessage() {
        return this.getClient().getMessageById(this.getInteraction().getChannelId(), this.getTargetId());
    }

    public Mono<Message> getTargetMessage(EntityRetrievalStrategy retrievalStrategy) {
        return this.getClient().withRetrievalStrategy(retrievalStrategy).getMessageById(this.getInteraction().getChannelId(), this.getTargetId());
    }
}

