/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain.guild;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.guild.GuildEvent;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.GuildSticker;
import discord4j.gateway.ShardInfo;
import java.util.Optional;
import java.util.Set;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class StickersUpdateEvent
extends GuildEvent {
    private final long guildId;
    private final Set<GuildSticker> stickers;
    @Nullable
    private final Set<GuildSticker> old;

    public StickersUpdateEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, long guildId, Set<GuildSticker> stickers, Set<GuildSticker> old) {
        super(gateway, shardInfo);
        this.guildId = guildId;
        this.stickers = stickers;
        this.old = old;
    }

    public Snowflake getGuildId() {
        return Snowflake.of(this.guildId);
    }

    public Mono<Guild> getGuild() {
        return this.getClient().getGuildById(this.getGuildId());
    }

    public Set<GuildSticker> getStickers() {
        return this.stickers;
    }

    public Optional<Set<GuildSticker>> getOld() {
        return Optional.ofNullable(this.old);
    }

    public String toString() {
        return "StickersUpdateEvent{guildId=" + this.guildId + ", stickers=" + this.stickers + ", old=" + this.old + '}';
    }
}

