/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.PartialMember;
import discord4j.discordjson.json.MemberData;
import reactor.core.publisher.Mono;

public final class Member
extends PartialMember {
    public Member(GatewayDiscordClient gateway, MemberData data, long guildId) {
        super(gateway, data.user(), data, guildId);
    }

    @Override
    public Mono<Member> asMember(Snowflake guildId) {
        return Mono.just(this).filter(member -> member.getGuildId().equals(guildId)).switchIfEmpty(super.asMember(guildId));
    }

    @Override
    public MemberData getMemberData() {
        return (MemberData)super.getMemberData();
    }

    @Override
    public Mono<Member> asFullMember() {
        return Mono.just(this);
    }

    public boolean isPending() {
        return this.getMemberData().pending().toOptional().orElse(false);
    }

    @Override
    public String toString() {
        return "Member{} " + super.toString();
    }
}

