/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity;

import discord4j.common.annotations.Experimental;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.discordjson.json.ThreadMemberData;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

@Experimental
public final class ThreadMember {
    private final GatewayDiscordClient gateway;
    private final ThreadMemberData data;

    public ThreadMember(GatewayDiscordClient gateway, ThreadMemberData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    public ThreadMemberData getData() {
        return this.data;
    }

    public Snowflake getThreadId() {
        return Snowflake.of(this.data.id().toOptional().orElseThrow(IllegalStateException::new));
    }

    public Snowflake getUserId() {
        return Snowflake.of(this.data.userId().toOptional().orElseThrow(IllegalStateException::new));
    }

    public Instant getJoinTimestamp() {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)this.data.joinTimestamp(), Instant::from);
    }

    public int getFlags() {
        return this.data.flags();
    }

    public String toString() {
        return "ThreadMember{gateway=" + this.gateway + ", data=" + this.data + '}';
    }
}

