/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.spec.EmbedCreateFields;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.InternalSpecUtils;
import discord4j.core.spec.Spec;
import discord4j.discordjson.json.EmbedAuthorData;
import discord4j.discordjson.json.EmbedData;
import discord4j.discordjson.json.EmbedFieldData;
import discord4j.discordjson.json.EmbedFooterData;
import discord4j.discordjson.json.EmbedImageData;
import discord4j.discordjson.json.EmbedThumbnailData;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Color;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import reactor.util.annotation.Nullable;

@Value.Immutable(singleton=true)
interface EmbedCreateSpecGenerator
extends Spec<EmbedData> {
    public Possible<String> title();

    public Possible<String> description();

    public Possible<String> url();

    public Possible<Instant> timestamp();

    public Possible<Color> color();

    @Nullable
    public EmbedCreateFields.Footer footer();

    public Possible<String> image();

    public Possible<String> thumbnail();

    @Nullable
    public EmbedCreateFields.Author author();

    @Value.Default
    default public List<EmbedCreateFields.Field> fields() {
        return Collections.emptyList();
    }

    @Override
    default public EmbedData asRequest() {
        return EmbedData.builder().title(this.title()).description(this.description()).url(this.url()).timestamp(InternalSpecUtils.mapPossible(this.timestamp(), DateTimeFormatter.ISO_INSTANT::format)).color(InternalSpecUtils.mapPossible(this.color(), Color::getRGB)).footer(InternalSpecUtils.mapPossible(InternalSpecUtils.toPossible(this.footer()), EmbedCreateFields.Footer::asRequest)).image(InternalSpecUtils.mapPossible(this.image(), url -> EmbedImageData.builder().url((String)url).build())).thumbnail(InternalSpecUtils.mapPossible(this.thumbnail(), url -> EmbedThumbnailData.builder().url((String)url).build())).author(InternalSpecUtils.mapPossible(InternalSpecUtils.toPossible(this.author()), EmbedCreateFields.Author::asRequest)).fields(this.fields().stream().map(EmbedCreateFields.Field::asRequest).collect(Collectors.toList())).build();
    }

    public static abstract class Builder {
        public EmbedCreateSpec.Builder from(EmbedData data) {
            EmbedCreateSpec.Builder $this = ((EmbedCreateSpec.Builder)EmbedCreateSpec.Builder.class.cast(this)).title(data.title()).description(data.description()).url(data.url()).timestamp(InternalSpecUtils.mapPossible(data.timestamp(), Instant::parse)).color(InternalSpecUtils.mapPossible(data.color(), Color::of)).image(InternalSpecUtils.flatMapPossible(data.image(), EmbedImageData::url)).thumbnail(InternalSpecUtils.flatMapPossible(data.thumbnail(), EmbedThumbnailData::url));
            if (!data.footer().isAbsent()) {
                EmbedFooterData footer = data.footer().get();
                $this.footer(footer.text(), footer.iconUrl().toOptional().orElse(null));
            } else {
                $this.footer(null);
            }
            if (!data.author().isAbsent()) {
                EmbedAuthorData author = data.author().get();
                $this.author(EmbedCreateFields.Author.of(author.name().toOptional().orElseThrow(IllegalStateException::new), Possible.flatOpt(author.url()).orElse(null), author.iconUrl().toOptional().orElse(null)));
            } else {
                $this.author(null);
            }
            if (!data.fields().isAbsent()) {
                List<EmbedFieldData> fields = data.fields().get();
                $this.fields(fields.stream().map(field -> EmbedCreateFields.Field.of(field.name(), field.value(), field.inline().toOptional().orElse(false))).collect(Collectors.toList()));
            } else {
                $this.fields(Collections.emptyList());
            }
            return $this;
        }
    }
}

