/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.core.spec.StageInstanceEditSpecGenerator;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="StageInstanceEditSpecGenerator", generator="Immutables")
public final class StageInstanceEditSpec
implements StageInstanceEditSpecGenerator {
    @Nullable
    private final String reason;
    private final String topic_value;
    private final boolean topic_absent;
    private final Integer privacyLevel_value;
    private final boolean privacyLevel_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final StageInstanceEditSpec INSTANCE = StageInstanceEditSpec.validate(new StageInstanceEditSpec());

    private StageInstanceEditSpec() {
        this.reason = null;
        Possible topic$impl = Possible.absent();
        Possible privacyLevel$impl = Possible.absent();
        this.topic_value = topic$impl.toOptional().orElse(null);
        this.topic_absent = topic$impl.isAbsent();
        this.privacyLevel_value = privacyLevel$impl.toOptional().orElse(null);
        this.privacyLevel_absent = privacyLevel$impl.isAbsent();
        this.initShim = null;
    }

    private StageInstanceEditSpec(@Nullable String reason, Possible<String> topic, Possible<Integer> privacyLevel) {
        this.reason = reason;
        Possible<String> topic$impl = topic;
        Possible<Integer> privacyLevel$impl = privacyLevel;
        this.topic_value = topic$impl.toOptional().orElse(null);
        this.topic_absent = topic$impl.isAbsent();
        this.privacyLevel_value = privacyLevel$impl.toOptional().orElse(null);
        this.privacyLevel_absent = privacyLevel$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public Possible<String> topic() {
        return this.topic_absent ? Possible.absent() : Possible.of(this.topic_value);
    }

    @Override
    public Possible<Integer> privacyLevel() {
        return this.privacyLevel_absent ? Possible.absent() : Possible.of(this.privacyLevel_value);
    }

    public final StageInstanceEditSpec withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return StageInstanceEditSpec.validate(new StageInstanceEditSpec(value, this.topic(), this.privacyLevel()));
    }

    public StageInstanceEditSpec withTopic(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return StageInstanceEditSpec.validate(new StageInstanceEditSpec(this.reason, newValue, this.privacyLevel()));
    }

    public StageInstanceEditSpec withTopic(String value) {
        Possible<String> newValue = Possible.of(value);
        return StageInstanceEditSpec.validate(new StageInstanceEditSpec(this.reason, newValue, this.privacyLevel()));
    }

    public StageInstanceEditSpec withPrivacyLevel(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return StageInstanceEditSpec.validate(new StageInstanceEditSpec(this.reason, this.topic(), newValue));
    }

    public StageInstanceEditSpec withPrivacyLevel(Integer value) {
        Possible<Integer> newValue = Possible.of(value);
        return StageInstanceEditSpec.validate(new StageInstanceEditSpec(this.reason, this.topic(), newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof StageInstanceEditSpec && this.equalTo(0, (StageInstanceEditSpec)another);
    }

    private boolean equalTo(int synthetic, StageInstanceEditSpec another) {
        return Objects.equals(this.reason, another.reason) && this.topic().equals(another.topic()) && this.privacyLevel().equals(another.privacyLevel());
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.reason);
        h2 += (h2 << 5) + this.topic().hashCode();
        h2 += (h2 << 5) + this.privacyLevel().hashCode();
        return h2;
    }

    public String toString() {
        return "StageInstanceEditSpec{reason=" + this.reason + ", topic=" + this.topic().toString() + ", privacyLevel=" + this.privacyLevel().toString() + "}";
    }

    public static StageInstanceEditSpec create() {
        return INSTANCE;
    }

    private static StageInstanceEditSpec validate(StageInstanceEditSpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    static StageInstanceEditSpec copyOf(StageInstanceEditSpecGenerator instance) {
        if (instance instanceof StageInstanceEditSpec) {
            return (StageInstanceEditSpec)instance;
        }
        return StageInstanceEditSpec.builder().from(instance).build();
    }

    public boolean isTopicPresent() {
        return !this.topic_absent;
    }

    public String topicOrElse(String defaultValue) {
        return !this.topic_absent ? this.topic_value : defaultValue;
    }

    public boolean isPrivacyLevelPresent() {
        return !this.privacyLevel_absent;
    }

    public Integer privacyLevelOrElse(Integer defaultValue) {
        return !this.privacyLevel_absent ? this.privacyLevel_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StageInstanceEditSpecGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build StageInstanceEditSpec, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="StageInstanceEditSpecGenerator", generator="Immutables")
    public static final class Builder {
        private Possible<String> topic_possible = Possible.absent();
        private Possible<Integer> privacyLevel_possible = Possible.absent();
        private String reason;

        private Builder() {
        }

        public final Builder from(StageInstanceEditSpec instance) {
            return this.from((StageInstanceEditSpecGenerator)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(StageInstanceEditSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            this.topic(instance.topic());
            this.privacyLevel(instance.privacyLevel());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reason(@Nullable String reason) {
            this.reason = reason;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder topic(Possible<String> value) {
            this.topic_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder topic(String value) {
            this.topic_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder privacyLevel(Possible<Integer> value) {
            this.privacyLevel_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder privacyLevel(Integer value) {
            this.privacyLevel_possible = Possible.of(value);
            return this;
        }

        public StageInstanceEditSpec build() {
            return StageInstanceEditSpec.validate(new StageInstanceEditSpec(this.reason, this.topic_build(), this.privacyLevel_build()));
        }

        private Possible<String> topic_build() {
            return this.topic_possible;
        }

        private Possible<Integer> privacyLevel_build() {
            return this.privacyLevel_possible;
        }
    }
}

