/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain.interaction;

import discord4j.common.annotations.Experimental;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.interaction.AutoCompleteInteractionEvent;
import discord4j.core.object.command.ApplicationCommand;
import discord4j.core.object.command.ApplicationCommandInteraction;
import discord4j.core.object.command.ApplicationCommandInteractionOption;
import discord4j.core.object.command.Interaction;
import discord4j.discordjson.json.ApplicationCommandOptionChoiceData;
import discord4j.discordjson.json.ImmutableInteractionApplicationCommandCallbackData;
import discord4j.discordjson.json.InteractionApplicationCommandCallbackData;
import discord4j.gateway.ShardInfo;
import discord4j.rest.util.InteractionResponseType;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import reactor.core.publisher.Mono;

@Experimental
public class ChatInputAutoCompleteEvent
extends AutoCompleteInteractionEvent {
    public ChatInputAutoCompleteEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, Interaction interaction) {
        super(gateway, shardInfo, interaction);
    }

    public Mono<Void> respondWithSuggestions(Iterable<ApplicationCommandOptionChoiceData> choices) {
        ImmutableInteractionApplicationCommandCallbackData data = InteractionApplicationCommandCallbackData.builder().choices(choices).build();
        return this.createInteractionResponse(InteractionResponseType.APPLICATION_COMMAND_AUTOCOMPLETE_RESULT, data);
    }

    public Snowflake getCommandId() {
        return (Snowflake)this.getInteraction().getCommandInteraction().flatMap(ApplicationCommandInteraction::getId).orElseThrow(IllegalStateException::new);
    }

    public String getCommandName() {
        return (String)this.getInteraction().getCommandInteraction().flatMap(ApplicationCommandInteraction::getName).orElseThrow(IllegalStateException::new);
    }

    public ApplicationCommand.Type getCommandType() {
        return (ApplicationCommand.Type)((Object)this.getInteraction().getCommandInteraction().flatMap(ApplicationCommandInteraction::getApplicationCommandType).orElseThrow(IllegalStateException::new));
    }

    public List<ApplicationCommandInteractionOption> getOptions() {
        return this.getInteraction().getCommandInteraction().orElseThrow(IllegalStateException::new).getOptions();
    }

    public Optional<ApplicationCommandInteractionOption> getOption(String name) {
        return this.getInteraction().getCommandInteraction().orElseThrow(IllegalStateException::new).getOption(name);
    }

    public ApplicationCommandInteractionOption getFocusedOption() {
        return (ApplicationCommandInteractionOption)this.getOptions().stream().map(this::getFocusedOption).filter(Optional::isPresent).findFirst().flatMap(Function.identity()).orElseThrow(() -> new IllegalStateException("No focused option found"));
    }

    private Optional<ApplicationCommandInteractionOption> getFocusedOption(ApplicationCommandInteractionOption opt) {
        if (opt.isFocused()) {
            return Optional.of(opt);
        }
        return opt.getOptions().stream().map(this::getFocusedOption).filter(Optional::isPresent).findFirst().flatMap(Function.identity());
    }
}

