/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.component;

import discord4j.core.object.component.ActionComponent;
import discord4j.core.object.component.MessageComponent;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.object.reaction.ReactionEmoji;
import discord4j.discordjson.json.ComponentData;
import discord4j.discordjson.json.ImmutableComponentData;
import discord4j.discordjson.json.SelectOptionData;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import reactor.util.annotation.Nullable;

public class SelectMenu
extends ActionComponent {
    public static SelectMenu of(String customId, Option ... options) {
        return SelectMenu.of(MessageComponent.Type.SELECT_MENU, customId, Arrays.asList(options), null);
    }

    public static SelectMenu of(String customId, List<Option> options) {
        Objects.requireNonNull(options);
        return SelectMenu.of(MessageComponent.Type.SELECT_MENU, customId, options, null);
    }

    public static SelectMenu ofRole(String customId) {
        return SelectMenu.of(MessageComponent.Type.SELECT_MENU_ROLE, customId, null, null);
    }

    public static SelectMenu ofUser(String customId) {
        return SelectMenu.of(MessageComponent.Type.SELECT_MENU_USER, customId, null, null);
    }

    public static SelectMenu ofMentionable(String customId) {
        return SelectMenu.of(MessageComponent.Type.SELECT_MENU_MENTIONABLE, customId, null, null);
    }

    public static SelectMenu ofChannel(String customId, Channel.Type ... channelTypes) {
        return SelectMenu.of(MessageComponent.Type.SELECT_MENU_CHANNEL, customId, null, Arrays.asList(channelTypes));
    }

    public static SelectMenu ofChannel(String customId, List<Channel.Type> channelTypes) {
        return SelectMenu.of(MessageComponent.Type.SELECT_MENU_CHANNEL, customId, null, channelTypes);
    }

    private static SelectMenu of(MessageComponent.Type type, String customId, @Nullable List<Option> options, @Nullable List<Channel.Type> channelTypes) {
        ImmutableComponentData.Builder builder = ComponentData.builder().type(type.getValue()).customId(customId);
        if (options != null) {
            builder.options(options.stream().map(opt -> ((Option)opt).data).collect(Collectors.toList()));
        }
        if (channelTypes != null) {
            builder.channelTypes(channelTypes.stream().map(Channel.Type::getValue).collect(Collectors.toList()));
        }
        return new SelectMenu(builder.build());
    }

    SelectMenu(ComponentData data) {
        super(data);
    }

    public String getCustomId() {
        return this.getData().customId().toOptional().orElseThrow(IllegalStateException::new);
    }

    public Optional<List<String>> getValues() {
        return this.getData().values().toOptional();
    }

    public Set<Channel.Type> getAllowedChannelTypes() {
        return this.getData().channelTypes().toOptional().orElse(Collections.emptyList()).stream().map(Channel.Type::of).collect(Collectors.toCollection(() -> EnumSet.noneOf(Channel.Type.class)));
    }

    public Optional<String> getPlaceholder() {
        return this.getData().placeholder().toOptional();
    }

    public int getMinValues() {
        return this.getData().minValues().toOptional().orElse(1);
    }

    public int getMaxValues() {
        return this.getData().maxValues().toOptional().orElse(1);
    }

    public List<Option> getOptions() {
        return this.getData().options().toOptional().orElse(Collections.emptyList()).stream().map(Option::new).collect(Collectors.toList());
    }

    public boolean isDisabled() {
        return this.getData().disabled().toOptional().orElse(false);
    }

    public SelectMenu disabled() {
        return this.disabled(true);
    }

    public SelectMenu disabled(boolean value) {
        return new SelectMenu(ComponentData.builder().from(this.getData()).disabled(value).build());
    }

    public SelectMenu withPlaceholder(String placeholder) {
        return new SelectMenu(ComponentData.builder().from(this.getData()).placeholder(placeholder).build());
    }

    public SelectMenu withMinValues(int minValues) {
        return new SelectMenu(ComponentData.builder().from(this.getData()).minValues(minValues).build());
    }

    public SelectMenu withMaxValues(int maxValues) {
        return new SelectMenu(ComponentData.builder().from(this.getData()).maxValues(maxValues).build());
    }

    public SelectMenu withAllowedChannelTypes(Iterable<Channel.Type> types) {
        if (this.getType() != MessageComponent.Type.SELECT_MENU_CHANNEL) {
            throw new IllegalArgumentException("Select menu with type " + (Object)((Object)this.getType()) + " can't have channel types restriction");
        }
        return new SelectMenu(ComponentData.builder().from(this.getData()).channelTypes(StreamSupport.stream(types.spliterator(), false).map(Channel.Type::getValue).collect(Collectors.toList())).build());
    }

    public SelectMenu withAllowedChannelTypes(Channel.Type ... types) {
        if (this.getType() != MessageComponent.Type.SELECT_MENU_CHANNEL) {
            throw new IllegalArgumentException("Select menu with type " + (Object)((Object)this.getType()) + " can't have channel types restriction");
        }
        return new SelectMenu(ComponentData.builder().from(this.getData()).channelTypes(Arrays.stream(types).map(Channel.Type::getValue).collect(Collectors.toList())).build());
    }

    public static class Option {
        private final SelectOptionData data;

        public static Option of(String label, String value) {
            return Option.of(label, value, false);
        }

        public static Option ofDefault(String label, String value) {
            return Option.of(label, value, true);
        }

        private static Option of(String label, String value, boolean isDefault) {
            return new Option(SelectOptionData.builder().label(label).value(value).isDefault(isDefault).build());
        }

        Option(SelectOptionData data) {
            this.data = data;
        }

        public String getLabel() {
            return this.data.label();
        }

        public String getValue() {
            return this.data.value();
        }

        public Optional<String> getDescription() {
            return this.data.description().toOptional();
        }

        public Optional<ReactionEmoji> getEmoji() {
            return this.data.emoji().toOptional().map(ReactionEmoji::of);
        }

        public boolean isDefault() {
            return this.data.isDefault().toOptional().orElse(false);
        }

        public Option withDescription(String description) {
            return new Option(SelectOptionData.builder().from(this.data).description(description).build());
        }

        public Option withEmoji(ReactionEmoji emoji) {
            return new Option(SelectOptionData.builder().from(this.data).emoji(emoji.asEmojiData()).build());
        }

        public Option withDefault(boolean isDefault) {
            return new Option(SelectOptionData.builder().from(this.data).isDefault(isDefault).build());
        }
    }
}

