/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.process;

import com.github.kokorin.jaffree.JaffreeException;
import com.github.kokorin.jaffree.process.Executor;
import com.github.kokorin.jaffree.process.GobblingStdReader;
import com.github.kokorin.jaffree.process.JaffreeAbnormalExitException;
import com.github.kokorin.jaffree.process.ProcessHelper;
import com.github.kokorin.jaffree.process.StdReader;
import com.github.kokorin.jaffree.process.Stopper;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessHandler<T> {
    private final Path executable;
    private final String contextName;
    private StdReader<T> stdOutReader = new GobblingStdReader();
    private StdReader<T> stdErrReader = new GobblingStdReader();
    private List<ProcessHelper> helpers = null;
    private Stopper stopper = null;
    private List<String> arguments = Collections.emptyList();
    private int executorTimeoutMillis = 10000;
    private static final int DEFAULT_EXECUTOR_TIMEOUT_MILLIS = 10000;
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessHandler.class);

    public ProcessHandler(Path executable, String contextName) {
        this.executable = executable;
        this.contextName = contextName;
    }

    public synchronized ProcessHandler<T> setStdOutReader(StdReader<T> stdOutReader) {
        this.stdOutReader = stdOutReader;
        return this;
    }

    public synchronized ProcessHandler<T> setStdErrReader(StdReader<T> stdErrReader) {
        this.stdErrReader = stdErrReader;
        return this;
    }

    public synchronized ProcessHandler<T> setHelpers(List<ProcessHelper> helpers) {
        this.helpers = helpers;
        return this;
    }

    public synchronized ProcessHandler<T> setStopper(Stopper stopper) {
        this.stopper = stopper;
        return this;
    }

    public synchronized ProcessHandler<T> setArguments(List<String> arguments) {
        this.arguments = arguments;
        return this;
    }

    public void setExecutorTimeoutMillis(int executorTimeoutMillis) {
        if (executorTimeoutMillis < 0) {
            throw new IllegalArgumentException("Executor timeout cannot be negative");
        }
        this.executorTimeoutMillis = executorTimeoutMillis;
    }

    /*
     * Loose catch block
     */
    public synchronized T execute() {
        try {
            T t;
            ArrayList<String> command = new ArrayList<String>();
            command.add(this.executable.toString());
            command.addAll(this.arguments);
            LOGGER.info("Command constructed:\n{}", (Object)ProcessHandler.joinArguments(command));
            Process process = null;
            try {
                LOGGER.info("Starting process: {}", (Object)this.executable);
                process = new ProcessBuilder(command).start();
                if (this.stopper != null) {
                    this.stopper.setProcess(process);
                }
                t = this.interactWithProcess(process);
            }
            catch (IOException e) {
                ProcessHandler.collectDebugInformation();
                throw new JaffreeException("Failed to start process.", e);
            }
            finally {
                if (process != null) {
                    process.destroy();
                    ProcessHandler.closeQuietly(process.getInputStream());
                    ProcessHandler.closeQuietly(process.getOutputStream());
                    ProcessHandler.closeQuietly(process.getErrorStream());
                }
            }
            return t;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ProcessHandler.closeQuietly(this.helpers);
        }
    }

    protected T interactWithProcess(Process process) {
        int status;
        AtomicReference resultRef = new AtomicReference();
        Executor executor = this.startExecution(process, resultRef);
        try {
            LOGGER.info("Waiting for process to finish");
            status = process.waitFor();
            LOGGER.info("Process has finished with status: {}", (Object)status);
            ProcessHandler.waitForExecutorToStop(executor, this.executorTimeoutMillis);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Process has been interrupted");
            if (this.stopper != null) {
                this.stopper.forceStop();
            }
            throw new JaffreeException("Failed to execute, was interrupted", e, executor.getExceptions());
        }
        finally {
            executor.stop();
        }
        List<Throwable> exceptions = executor.getExceptions();
        if (exceptions != null && !exceptions.isEmpty()) {
            throw new JaffreeException("Failed to execute, exception appeared in one of helper threads", exceptions);
        }
        if (status != 0) {
            throw new JaffreeAbnormalExitException("Process execution has ended with non-zero status: " + status + ". Check logs for detailed error message.", this.stdErrReader.getErrorLogMessages());
        }
        Object result = resultRef.get();
        if (result == null) {
            throw new JaffreeException("Process execution has ended with null result");
        }
        return (T)result;
    }

    protected Executor startExecution(final Process process, final AtomicReference<T> resultReference) {
        Executor executor = new Executor(this.contextName);
        LOGGER.debug("Starting IO interaction with process");
        if (this.stdErrReader != null) {
            executor.execute("StdErr", new Runnable(){

                @Override
                public void run() {
                    boolean set;
                    Object errResult = ProcessHandler.this.stdErrReader.read(process.getErrorStream());
                    if (errResult != null && !(set = resultReference.compareAndSet(null, errResult))) {
                        LOGGER.warn("Ignored result of reading STD ERR: {}", errResult);
                    }
                }
            });
        }
        if (this.stdOutReader != null) {
            executor.execute("StdOut", new Runnable(){

                @Override
                public void run() {
                    boolean set;
                    Object result = ProcessHandler.this.stdOutReader.read(process.getInputStream());
                    if (result != null && !(set = resultReference.compareAndSet(null, result))) {
                        LOGGER.warn("Ignored result of reading STD OUT: {}", result);
                    }
                }
            });
        }
        if (this.helpers != null) {
            for (int i = 0; i < this.helpers.size(); ++i) {
                Runnable runnable = this.helpers.get(i);
                executor.execute("Runnable-" + i, runnable);
            }
        }
        return executor;
    }

    protected static String joinArguments(List<String> arguments) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String argument : arguments) {
            if (!first) {
                result.append(" ");
            }
            String quote = argument.contains(" ") ? "\"" : "";
            result.append(quote).append(argument).append(quote);
            first = false;
        }
        return result.toString();
    }

    private static void closeQuietly(Closeable toClose) {
        try {
            if (toClose != null) {
                toClose.close();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Ignoring exception: " + e.getMessage());
        }
    }

    private static void closeQuietly(Collection<? extends Closeable> toClose) {
        if (toClose == null) {
            return;
        }
        for (Closeable closeable : toClose) {
            ProcessHandler.closeQuietly(closeable);
        }
    }

    private static void waitForExecutorToStop(Executor executor, long timeoutMillis) throws InterruptedException {
        LOGGER.debug("Waiting for Executor to stop");
        long waitStarted = System.currentTimeMillis();
        do {
            if (timeoutMillis > 0L && System.currentTimeMillis() - waitStarted > timeoutMillis) {
                LOGGER.warn("Executor hasn't stopped in {} millis, won't wait longer", (Object)timeoutMillis);
                break;
            }
            LOGGER.trace("Executor hasn't yet stopped, still running threads: {}", (Object)executor.getRunningThreadNames());
            Thread.sleep(100L);
        } while (executor.isRunning());
    }

    private static void collectDebugInformation() {
        try {
            LOGGER.warn("Collecting debug information");
            LOGGER.warn("User: {}", (Object)System.getProperty("user.name"));
            LOGGER.warn("OS: {}", (Object)System.getProperty("os.name"));
            LOGGER.warn("User Dir: {}", (Object)System.getProperty("user.dir"));
            LOGGER.warn("Work Dir: {}", (Object)Paths.get(".", new String[0]).toAbsolutePath());
            LOGGER.warn("PATH: {}", (Object)System.getenv("PATH"));
        }
        catch (Exception e) {
            LOGGER.warn("Failure while collecting debug information.", e);
        }
    }
}

