/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.util;

import com.github.kokorin.jaffree.LogLevel;
import com.github.kokorin.jaffree.ffmpeg.FFmpegResult;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParseUtil {
    private static final String KBYTES_SUFFIX = "kB";
    private static final String KBITS_PER_SECOND_SUFFIX = "kbits/s";
    private static final String SPEED_SUFFIX = "x";
    private static final String PERCENT_SUFFIX = "%";
    private static final Logger LOGGER = LoggerFactory.getLogger(ParseUtil.class);

    private ParseUtil() {
    }

    public static Long parseLong(String value) {
        if (value != null && !value.isEmpty() && !"N/A".equals(value)) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Failed to parse long number: {}", (Object)value, (Object)e);
            }
        }
        return null;
    }

    public static Double parseDouble(String value) {
        if (value != null && !value.isEmpty() && !"N/A".equals(value)) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Failed to parse double number: {}", (Object)value, (Object)e);
            }
        }
        return null;
    }

    public static Long parseSizeInBytes(String value) {
        Long result = ParseUtil.parseSizeInKiloBytes(value);
        if (result == null) {
            return null;
        }
        return result * 1000L;
    }

    public static Long parseSizeInKiloBytes(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        return ParseUtil.parseLongWithSuffix(value.trim(), KBYTES_SUFFIX);
    }

    public static Double parseBitrateInKBits(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        return ParseUtil.parseDoubleWithSuffix(value.trim(), KBITS_PER_SECOND_SUFFIX);
    }

    public static Double parseSpeed(String value) {
        return ParseUtil.parseDoubleWithSuffix(value, SPEED_SUFFIX);
    }

    public static Double parsePercentsAsRatio(String value) {
        Double percents = ParseUtil.parseDoubleWithSuffix(value, PERCENT_SUFFIX);
        if (percents == null) {
            return null;
        }
        return percents / 100.0;
    }

    private static Long parseLongWithSuffix(String value, String suffix) {
        String numericValue = ParseUtil.removeSuffix(value, suffix);
        return ParseUtil.parseLong(numericValue);
    }

    private static Double parseDoubleWithSuffix(String value, String suffix) {
        String numericValue = ParseUtil.removeSuffix(value, suffix);
        return ParseUtil.parseDouble(numericValue);
    }

    private static String removeSuffix(String value, String suffix) {
        if (value == null || value.isEmpty() || !value.endsWith(suffix)) {
            return null;
        }
        return value.substring(0, value.length() - suffix.length());
    }

    public static LogLevel parseLogLevel(String line) {
        int offset;
        if (line == null || line.isEmpty()) {
            return null;
        }
        LogLevel result = ParseUtil.parseLogLevel(line, 0);
        if (result == null && (offset = line.indexOf(91, 1)) != -1 && (result = ParseUtil.parseLogLevel(line, offset)) == null) {
            offset = line.indexOf(91, offset + 1);
            result = ParseUtil.parseLogLevel(line, offset);
        }
        return result;
    }

    private static LogLevel parseLogLevel(String line, int offset) {
        if (line.regionMatches(offset, "[info]", 0, 6)) {
            return LogLevel.INFO;
        }
        if (line.regionMatches(offset, "[verbose]", 0, 9)) {
            return LogLevel.VERBOSE;
        }
        if (line.regionMatches(offset, "[debug]", 0, 7)) {
            return LogLevel.DEBUG;
        }
        if (line.regionMatches(offset, "[warning]", 0, 9)) {
            return LogLevel.WARNING;
        }
        if (line.regionMatches(offset, "[error]", 0, 7)) {
            return LogLevel.ERROR;
        }
        if (line.regionMatches(offset, "[trace]", 0, 7) || line.regionMatches(offset, "[]", 0, 2)) {
            return LogLevel.TRACE;
        }
        if (line.regionMatches(offset, "[quiet]", 0, 7)) {
            return LogLevel.QUIET;
        }
        if (line.regionMatches(offset, "[panic]", 0, 7)) {
            return LogLevel.PANIC;
        }
        if (line.regionMatches(offset, "[fatal]", 0, 7)) {
            return LogLevel.FATAL;
        }
        return null;
    }

    public static FFmpegResult parseResult(String line) {
        if (line == null || line.isEmpty()) {
            return null;
        }
        try {
            String valueWithoutSpaces = line.replaceAll("other streams", "other_streams").replaceAll("global headers", "global_headers").replaceAll("muxing overhead", "muxing_overhead").replaceAll(":\\s+", ":");
            Map<String, String> map = ParseUtil.parseKeyValues(valueWithoutSpaces, ":");
            Long videoSize = ParseUtil.parseSizeInBytes(map.get("video"));
            Long audioSize = ParseUtil.parseSizeInBytes(map.get("audio"));
            Long subtitleSize = ParseUtil.parseSizeInBytes(map.get("subtitle"));
            Long otherStreamsSize = ParseUtil.parseSizeInBytes(map.get("other_streams"));
            Long globalHeadersSize = ParseUtil.parseSizeInBytes(map.get("global_headers"));
            Double muxOverheadRatio = ParseUtil.parsePercentsAsRatio(map.get("muxing_overhead"));
            if (videoSize != null || audioSize != null || subtitleSize != null || otherStreamsSize != null || globalHeadersSize != null || muxOverheadRatio != null) {
                return new FFmpegResult(videoSize, audioSize, subtitleSize, otherStreamsSize, globalHeadersSize, muxOverheadRatio);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to parse result: {}", (Object)line, (Object)e);
        }
        return null;
    }

    private static Map<String, String> parseKeyValues(String value, String separator) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String pair : value.split("\\s+")) {
            String[] nameAndValue = pair.split(separator);
            if (nameAndValue.length != 2) continue;
            result.put(nameAndValue[0], nameAndValue[1]);
        }
        return result;
    }
}

