/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.console.command.commands;

import com.gmail.berndivader.streamserver.annotation.ConsoleCommand;
import com.gmail.berndivader.streamserver.console.command.Command;
import com.gmail.berndivader.streamserver.term.ANSI;
import com.gmail.berndivader.streamserver.youtube.BroadcastStatus;
import com.gmail.berndivader.streamserver.youtube.Youtube;
import com.gmail.berndivader.streamserver.youtube.packets.EmptyPacket;
import com.gmail.berndivader.streamserver.youtube.packets.ErrorPacket;
import com.gmail.berndivader.streamserver.youtube.packets.LiveBroadcastPacket;
import com.gmail.berndivader.streamserver.youtube.packets.Packet;
import com.google.gson.JsonObject;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@ConsoleCommand(name="livestatus", usage="Get info and status of running live broadcast from Youtube.")
public class LivestreamsById
extends Command {
    @Override
    public boolean execute(String[] args) {
        String arg = args[0];
        boolean printJson = false;
        printJson = arg.contains("--json");
        Packet p = Packet.build(new JsonObject(), EmptyPacket.class);
        Future<Packet> future = Youtube.getLiveBroadcast(BroadcastStatus.active);
        try {
            p = future.get(15L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            ANSI.printErr("Error while waiting for Youtube response.", e);
        }
        if (p instanceof LiveBroadcastPacket) {
            LiveBroadcastPacket packet = (LiveBroadcastPacket)p;
            if (printJson) {
                ANSI.println(packet.source().toString());
            } else {
                StringBuilder out = new StringBuilder();
                out.append("[BLUE]Title: [YELLOW]".concat(packet.snippet.title));
                out.append("[BR][BLUE]Description: [YELLOW]".concat(packet.snippet.description));
                out.append("[BR][BLUE]Publish time: [YELLOW]".concat(packet.snippet.publishedAt));
                out.append("[BR][BLUE]Kind: [YELLOW]".concat(packet.kind));
                out.append("[BR][BLUE]Video URL: [YELLOW]https://www.youtube.com/watch?v=".concat(packet.id));
                out.append("[BR][BLUE]Channel URL: [YELLOW]https://www.youtube.com/channel/".concat(packet.snippet.channelId));
                ANSI.println(out.toString());
            }
        } else if (p instanceof ErrorPacket) {
            ErrorPacket packet = (ErrorPacket)p;
            packet.printSimple();
        } else if (p instanceof EmptyPacket) {
            ANSI.println("Currently, no live broadcast running.");
        }
        return true;
    }
}

