/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.discord.command.commands;

import com.gmail.berndivader.streamserver.Helper;
import com.gmail.berndivader.streamserver.annotation.DiscordCommand;
import com.gmail.berndivader.streamserver.annotation.Requireds;
import com.gmail.berndivader.streamserver.discord.command.Command;
import com.gmail.berndivader.streamserver.ffmpeg.BroadcastRunner;
import com.gmail.berndivader.streamserver.ffmpeg.FFProbePacket;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.channel.MessageChannel;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.MessageCreateMono;
import discord4j.rest.util.Color;
import java.io.File;
import java.util.Optional;
import reactor.core.publisher.Mono;

@DiscordCommand(name="play", usage="[filename|next|last|repeat]", requireds={Requireds.BROADCASTRUNNER})
public class Play
extends Command<Message> {
    @Override
    public Mono<Message> execute(String s2, MessageChannel channel) {
        MessageCreateMono mono = Mono.empty();
        switch (s2.toLowerCase()) {
            case "next": {
                mono = Play.createMessage(BroadcastRunner.getFiles()[BroadcastRunner.index.get()], channel);
                BroadcastRunner.next();
                break;
            }
            case "prev": {
                mono = Play.createMessage(BroadcastRunner.getFiles()[(BroadcastRunner.index.get() - 2 + BroadcastRunner.getFiles().length) % BroadcastRunner.getFiles().length], channel);
                BroadcastRunner.previous();
                break;
            }
            case "repeat": {
                if (BroadcastRunner.playing() != null) {
                    mono = Play.createMessage(BroadcastRunner.playing(), channel);
                    BroadcastRunner.restart();
                    break;
                }
                mono = Play.createMessage(BroadcastRunner.getFiles()[BroadcastRunner.index.get()], channel);
                BroadcastRunner.next();
                break;
            }
            default: {
                Optional<File> file = BroadcastRunner.getFileByName(s2);
                if (file.isPresent()) {
                    mono = Play.createMessage(file.get(), channel);
                    BroadcastRunner.playFile(file.get());
                    break;
                }
                mono = channel.createMessage(EmbedCreateSpec.builder().color(Color.RED).title("No file found for").description(s2).build());
            }
        }
        return mono;
    }

    private static Mono<Message> createMessage(File file, MessageChannel channel) {
        FFProbePacket packet = FFProbePacket.build(file);
        return channel.createMessage(EmbedCreateSpec.builder().title(packet.isSet(packet.tags.title) ? packet.tags.title : "Now playing...").author(packet.isSet(packet.tags.artist) ? packet.tags.artist : "", "", "").description(packet.isSet(packet.tags.description) ? packet.tags.description : file.getName()).addField("Duration", Helper.stringFloatToTime(packet.duration), false).build());
    }
}

