/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.mysql;

import com.gmail.berndivader.streamserver.Helper;
import com.gmail.berndivader.streamserver.config.Config;
import com.gmail.berndivader.streamserver.mysql.DatabaseConnection;
import com.gmail.berndivader.streamserver.term.ANSI;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class DeleteUnlinkedMediafiles
implements Callable<Boolean> {
    private static final String DOWNLOADABLES = "SELECT `uuid`,`path` FROM `downloadables`;";
    private static final String DELETE = "DELETE FROM `downloadables` WHERE `uuid` IN (%s);";
    public Future<Boolean> future = Helper.EXECUTOR.submit(this);

    @Override
    public Boolean call() {
        HashMap<String, String> media = new HashMap<String, String>();
        File[] files = null;
        File[] thumbnails = null;
        File tempDir = new File(Config.tempPath());
        File thumbDir = new File(Config.DL_WWW_THUMBNAIL_PATH);
        if (tempDir.exists()) {
            files = tempDir.listFiles(file -> file.isFile());
        }
        if (thumbDir.exists()) {
            thumbnails = thumbDir.listFiles(file -> file.isFile());
        }
        try (Connection connection = DatabaseConnection.getNewConnection();
             PreparedStatement downloadables = connection.prepareStatement(DOWNLOADABLES, 1004, 1007);){
            ResultSet resultSet = downloadables.executeQuery();
            while (resultSet.next()) {
                media.put(resultSet.getString(1), resultSet.getString(2));
            }
        }
        catch (SQLException e) {
            ANSI.printErr("Failed to collect downloadables from database.", e);
            return false;
        }
        Object values = "";
        for (Map.Entry entry : media.entrySet()) {
            if (!Files.notExists(Path.of((String)entry.getValue(), new String[0]), LinkOption.NOFOLLOW_LINKS)) continue;
            values = (String)values + (((String)values).length() == 0 ? "'" + (String)entry.getKey() + "'" : ",'" + (String)entry.getKey() + "'");
        }
        File[] unlinked = (File[])Arrays.stream(files).filter(file -> !media.containsValue(file.getAbsolutePath())).toArray(File[]::new);
        File[] fileArray = (File[])Arrays.stream(thumbnails).filter(file -> !media.containsKey(file.getName().replace(".jpg", ""))).toArray(File[]::new);
        int result = 0;
        if (!((String)values).isEmpty()) {
            String delete = String.format(DELETE, values);
            try (Connection connection = DatabaseConnection.getNewConnection();
                 PreparedStatement statement = connection.prepareStatement(delete, 1004, 1007);){
                result = statement.executeUpdate();
            }
            catch (SQLException e) {
                ANSI.printErr("Failed to delete dead entries from downloadables table.", e);
            }
        }
        ANSI.println("[YELLOW]Removed " + result + " entries from downloadables table.");
        Arrays.stream(unlinked).forEach(file -> file.delete());
        Arrays.stream(fileArray).forEach(file -> file.delete());
        ANSI.println("[YELLOW]Removed " + unlinked.length + " unlinked files from temp path.");
        ANSI.println("[YELLOW]Removed " + fileArray.length + " unlinked thumbnails from www path.");
        return true;
    }
}

