/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object;

import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.ThreadMember;
import discord4j.core.object.entity.channel.ThreadChannel;
import discord4j.core.util.EntityUtil;
import discord4j.discordjson.json.ListThreadsData;
import discord4j.discordjson.json.ThreadMemberData;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ThreadListPart {
    private final List<ThreadChannel> threads;
    private final List<ThreadMember> members;

    public ThreadListPart(GatewayDiscordClient client, ListThreadsData data) {
        this.threads = data.threads().stream().map(channelData -> (ThreadChannel)EntityUtil.getChannel(client, channelData)).collect(Collectors.toList());
        this.members = data.members().stream().map(threadMemberData -> new ThreadMember(client, (ThreadMemberData)threadMemberData)).collect(Collectors.toList());
    }

    private ThreadListPart(List<ThreadChannel> threads, List<ThreadMember> members) {
        this.threads = threads;
        this.members = members;
    }

    public List<ThreadChannel> getThreads() {
        return this.threads;
    }

    public List<ThreadMember> getMembers() {
        return this.members;
    }

    public ThreadListPart combine(ThreadListPart other) {
        ArrayList<ThreadChannel> combineThreads = new ArrayList<ThreadChannel>(this.threads.size() + other.threads.size());
        combineThreads.addAll(this.threads);
        combineThreads.addAll(other.threads);
        ArrayList<ThreadMember> combineMembers = new ArrayList<ThreadMember>(this.members.size() + other.members.size());
        combineMembers.addAll(this.members);
        combineMembers.addAll(other.members);
        return new ThreadListPart(combineThreads, combineMembers);
    }
}

