/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.Entity;
import discord4j.core.object.entity.Member;
import discord4j.core.spec.StageInstanceEditSpec;
import discord4j.core.util.EntityUtil;
import discord4j.discordjson.json.StageInstanceData;
import discord4j.discordjson.json.UpdateUserVoiceStateRequest;
import discord4j.rest.RestClient;
import discord4j.rest.entity.RestStageInstance;
import java.util.Objects;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public final class StageInstance
implements Entity {
    private final GatewayDiscordClient gateway;
    private final StageInstanceData data;
    private final RestStageInstance rest;

    public StageInstance(GatewayDiscordClient gateway, StageInstanceData data) {
        this.gateway = gateway;
        this.data = data;
        this.rest = RestStageInstance.create((RestClient)gateway.rest(), Snowflake.of(data.channelId()));
    }

    public Mono<StageInstance> edit(StageInstanceEditSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> this.rest.edit(spec.asRequest(), spec.reason()).map(bean -> new StageInstance(this.gateway, (StageInstanceData)bean)));
    }

    public Mono<Void> inviteMemberToStageSpeakers(Member member) {
        return Mono.defer(() -> this.gateway.getRestClient().getGuildService().modifyOthersVoiceState(member.getGuildId().asLong(), member.getId().asLong(), UpdateUserVoiceStateRequest.builder().suppress(false).build()));
    }

    public Mono<Void> moveMemberToStageAudience(Member member) {
        return Mono.defer(() -> this.gateway.getRestClient().getGuildService().modifyOthersVoiceState(member.getGuildId().asLong(), member.getId().asLong(), UpdateUserVoiceStateRequest.builder().suppress(true).build()));
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public StageInstanceData getData() {
        return this.data;
    }

    @Override
    public Snowflake getId() {
        return Snowflake.of(this.data.id());
    }

    public Snowflake getChannelId() {
        return Snowflake.of(this.data.channelId());
    }

    public boolean equals(@Nullable Object obj) {
        return EntityUtil.equals(this, obj);
    }

    public int hashCode() {
        return EntityUtil.hashCode(this);
    }

    public String toString() {
        return "StageInstance{data=" + this.data + '}';
    }
}

