/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity.channel;

import discord4j.common.util.Snowflake;
import discord4j.core.object.ExtendedInvite;
import discord4j.core.object.entity.channel.Category;
import discord4j.core.object.entity.channel.TopLevelGuildChannel;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.core.spec.InviteCreateMono;
import discord4j.core.spec.InviteCreateSpec;
import discord4j.core.spec.legacy.LegacyInviteCreateSpec;
import discord4j.discordjson.json.InviteData;
import discord4j.discordjson.possible.Possible;
import java.util.Optional;
import java.util.function.Consumer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface CategorizableChannel
extends TopLevelGuildChannel {
    default public int getRateLimitPerUser() {
        return this.getData().rateLimitPerUser().toOptional().orElseThrow(IllegalStateException::new);
    }

    default public Optional<Snowflake> getCategoryId() {
        return Possible.flatOpt(this.getData().parentId()).map(Snowflake::of);
    }

    default public Mono<Category> getCategory() {
        return Mono.justOrEmpty(this.getCategoryId()).flatMap(this.getClient()::getChannelById).cast(Category.class);
    }

    default public Mono<Category> getCategory(EntityRetrievalStrategy retrievalStrategy) {
        return Mono.justOrEmpty(this.getCategoryId()).flatMap(id -> this.getClient().withRetrievalStrategy(retrievalStrategy).getChannelById((Snowflake)id)).cast(Category.class);
    }

    @Deprecated
    default public Mono<ExtendedInvite> createInvite(Consumer<? super LegacyInviteCreateSpec> spec) {
        return Mono.defer(() -> {
            LegacyInviteCreateSpec mutatedSpec = new LegacyInviteCreateSpec();
            spec.accept(mutatedSpec);
            return this.getClient().getRestClient().getChannelService().createChannelInvite(this.getId().asLong(), mutatedSpec.asRequest(), mutatedSpec.getReason());
        }).map(data -> new ExtendedInvite(this.getClient(), (InviteData)data));
    }

    default public InviteCreateMono createInvite() {
        return InviteCreateMono.of(this);
    }

    default public Mono<ExtendedInvite> createInvite(InviteCreateSpec spec) {
        return Mono.defer(() -> this.getClient().getRestClient().getChannelService().createChannelInvite(this.getId().asLong(), spec.asRequest(), spec.reason())).map(data -> new ExtendedInvite(this.getClient(), (InviteData)data));
    }

    default public Flux<ExtendedInvite> getInvites() {
        return this.getClient().getRestClient().getChannelService().getChannelInvites(this.getId().asLong()).map(data -> new ExtendedInvite(this.getClient(), (InviteData)data));
    }
}

