/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity.channel;

import discord4j.common.annotations.Experimental;
import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.Entity;
import discord4j.core.util.MentionUtil;
import discord4j.discordjson.json.ChannelData;
import discord4j.rest.entity.RestChannel;
import java.util.EnumSet;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public interface Channel
extends Entity {
    default public Type getType() {
        return Type.of(this.getData().type());
    }

    @Override
    default public Snowflake getId() {
        return Snowflake.of(this.getData().id());
    }

    default public Mono<Void> delete() {
        return this.delete(null);
    }

    default public Mono<Void> delete(@Nullable String reason) {
        return this.getRestChannel().delete(reason);
    }

    default public String getMention() {
        return MentionUtil.forChannel(this.getId());
    }

    public RestChannel getRestChannel();

    public ChannelData getData();

    public static enum Type {
        UNKNOWN(-1),
        GUILD_TEXT(0),
        DM(1),
        GUILD_VOICE(2),
        GROUP_DM(3),
        GUILD_CATEGORY(4),
        GUILD_NEWS(5),
        GUILD_STORE(6),
        GUILD_NEWS_THREAD(10),
        GUILD_PUBLIC_THREAD(11),
        GUILD_PRIVATE_THREAD(12),
        GUILD_STAGE_VOICE(13),
        GUILD_FORUM(15);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Type of(int value) {
            switch (value) {
                case 0: {
                    return GUILD_TEXT;
                }
                case 1: {
                    return DM;
                }
                case 2: {
                    return GUILD_VOICE;
                }
                case 3: {
                    return GROUP_DM;
                }
                case 4: {
                    return GUILD_CATEGORY;
                }
                case 5: {
                    return GUILD_NEWS;
                }
                case 6: {
                    return GUILD_STORE;
                }
                case 10: {
                    return GUILD_NEWS_THREAD;
                }
                case 11: {
                    return GUILD_PUBLIC_THREAD;
                }
                case 12: {
                    return GUILD_PRIVATE_THREAD;
                }
                case 13: {
                    return GUILD_STAGE_VOICE;
                }
                case 15: {
                    return GUILD_FORUM;
                }
            }
            return UNKNOWN;
        }
    }

    @Experimental
    public static enum Flag {
        PINNED(1),
        REQUIRE_TAG(4);

        private final int shiftValue;
        private final int bitValue;

        private Flag(int shiftValue) {
            this.shiftValue = shiftValue;
            this.bitValue = 1 << shiftValue;
        }

        public int getShiftValue() {
            return this.shiftValue;
        }

        public int getBitValue() {
            return this.bitValue;
        }

        public static EnumSet<Flag> valueOf(int bitfield) {
            EnumSet<Flag> returnSet = EnumSet.noneOf(Flag.class);
            for (Flag flag : Flag.values()) {
                if ((bitfield & flag.getBitValue()) == 0) continue;
                returnSet.add(flag);
            }
            return returnSet;
        }

        public static int toBitfield(EnumSet<Flag> flags) {
            int bitfield = 0;
            for (Flag flag : flags) {
                bitfield |= flag.getBitValue();
            }
            return bitfield;
        }
    }
}

