/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity.channel;

import discord4j.common.annotations.Experimental;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.ForumTag;
import discord4j.core.object.entity.channel.BaseTopLevelGuildChannel;
import discord4j.core.object.entity.channel.CategorizableChannel;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.object.entity.channel.ThreadChannel;
import discord4j.core.object.reaction.DefaultReaction;
import discord4j.core.spec.ForumChannelEditSpec;
import discord4j.core.spec.StartThreadInForumChannelSpec;
import discord4j.core.util.EntityUtil;
import discord4j.discordjson.json.ChannelData;
import discord4j.discordjson.json.DefaultReactionData;
import discord4j.discordjson.json.ForumTagData;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

@Experimental
public final class ForumChannel
extends BaseTopLevelGuildChannel
implements CategorizableChannel {
    public ForumChannel(GatewayDiscordClient gateway, ChannelData data) {
        super(gateway, data);
    }

    public Optional<String> getTopic() {
        return this.getData().topic().toOptional().flatMap(opt -> opt);
    }

    public boolean isNsfw() {
        return this.getData().nsfw().toOptional().orElse(false);
    }

    public EnumSet<Channel.Flag> getFlags() {
        return this.getData().flags().toOptional().map(Channel.Flag::valueOf).orElseThrow(IllegalStateException::new);
    }

    public Optional<Integer> getDefaultAutoArchiveDuration() {
        return this.getData().defaultAutoArchiveDuration().toOptional();
    }

    public List<ForumTag> getAvailableTags() {
        return this.getData().availableTags().toOptional().orElseThrow(IllegalStateException::new).stream().map(forumTagData -> new ForumTag(this.getClient(), (ForumTagData)forumTagData)).collect(Collectors.toList());
    }

    public Optional<DefaultReaction> getDefaultReaction() {
        return this.getData().defaultReactionEmoji().toOptional().orElseThrow(IllegalStateException::new).map(defaultReactionData -> new DefaultReaction(this.getClient(), (DefaultReactionData)defaultReactionData));
    }

    public Optional<Integer> getDefaultThreadRateLimitPerUser() {
        return this.getData().defaultThreadRateLimitPerUser().toOptional();
    }

    public Optional<SortOrder> getSortOrder() {
        return this.getData().defaultSortOrder().toOptional().orElseThrow(IllegalStateException::new).map(SortOrder::valueOf);
    }

    public LayoutType getDefaultForumLayout() {
        return this.getData().defaultForumLayout().toOptional().map(LayoutType::valueOf).orElseThrow(IllegalStateException::new);
    }

    public Mono<ThreadChannel> startThread(StartThreadInForumChannelSpec request) {
        return this.getClient().getRestClient().getChannelService().startThreadInForumChannel(this.getId().asLong(), request.asRequest()).map(channelData -> new ThreadChannel(this.getClient(), (ChannelData)channelData));
    }

    public Mono<ForumChannel> edit(ForumChannelEditSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> this.getClient().getRestClient().getChannelService().modifyChannel(this.getId().asLong(), spec.asRequest(), spec.reason())).map(data -> EntityUtil.getChannel(this.getClient(), data)).cast(ForumChannel.class);
    }

    @Experimental
    public static enum LayoutType {
        UNKNOWN(-1),
        NOT_SET(0),
        LIST_VIEW(1),
        GALLERY_VIEW(2);

        private final int value;

        private LayoutType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static LayoutType valueOf(int value) {
            for (LayoutType layoutType : LayoutType.values()) {
                if (layoutType.getValue() != value) continue;
                return layoutType;
            }
            return UNKNOWN;
        }
    }

    @Experimental
    public static enum SortOrder {
        UNKNOWN(-1),
        LATEST_ACTIVITY(0),
        CREATION_DATE(1);

        private final int value;

        private SortOrder(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static SortOrder valueOf(int value) {
            for (SortOrder sortOrder : SortOrder.values()) {
                if (sortOrder.getValue() != value) continue;
                return sortOrder;
            }
            return UNKNOWN;
        }
    }
}

