/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity.channel;

import discord4j.core.object.ThreadListPart;
import discord4j.core.object.entity.Webhook;
import discord4j.core.object.entity.channel.CategorizableChannel;
import discord4j.core.object.entity.channel.GuildMessageChannel;
import discord4j.core.object.entity.channel.ThreadChannel;
import discord4j.core.spec.StartThreadWithoutMessageSpec;
import discord4j.core.spec.WebhookCreateMono;
import discord4j.core.spec.WebhookCreateSpec;
import discord4j.core.spec.legacy.LegacyWebhookCreateSpec;
import discord4j.discordjson.json.ChannelData;
import discord4j.discordjson.json.ListThreadsData;
import discord4j.discordjson.json.WebhookData;
import discord4j.discordjson.possible.Possible;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface TopLevelGuildMessageChannel
extends CategorizableChannel,
GuildMessageChannel {
    default public Optional<String> getTopic() {
        return Possible.flatOpt(this.getData().topic());
    }

    default public Mono<Webhook> createWebhook(Consumer<? super LegacyWebhookCreateSpec> spec) {
        return Mono.defer(() -> {
            LegacyWebhookCreateSpec mutatedSpec = new LegacyWebhookCreateSpec();
            spec.accept(mutatedSpec);
            return this.getClient().getRestClient().getWebhookService().createWebhook(this.getId().asLong(), mutatedSpec.asRequest(), mutatedSpec.getReason());
        }).map(data -> new Webhook(this.getClient(), (WebhookData)data));
    }

    default public WebhookCreateMono createWebhook(String name) {
        return WebhookCreateMono.of(name, this);
    }

    default public Mono<Webhook> createWebhook(WebhookCreateSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> this.getClient().getRestClient().getWebhookService().createWebhook(this.getId().asLong(), spec.asRequest(), spec.reason())).map(data -> new Webhook(this.getClient(), (WebhookData)data));
    }

    default public Flux<Webhook> getWebhooks() {
        return this.getClient().getRestClient().getWebhookService().getChannelWebhooks(this.getId().asLong()).map(data -> new Webhook(this.getClient(), (WebhookData)data));
    }

    default public Mono<ThreadChannel> startThread(StartThreadWithoutMessageSpec spec) {
        return this.getClient().getRestClient().getChannelService().startThreadWithoutMessage(this.getId().asLong(), spec.asRequest()).map(data -> new ThreadChannel(this.getClient(), (ChannelData)data));
    }

    default public Flux<ThreadListPart> getPublicArchivedThreads() {
        return this.getRestChannel().getPublicArchivedThreads().map(data -> new ThreadListPart(this.getClient(), (ListThreadsData)data));
    }

    default public Flux<ThreadListPart> getPrivateArchivedThreads() {
        return this.getRestChannel().getPrivateArchivedThreads().map(data -> new ThreadListPart(this.getClient(), (ListThreadsData)data));
    }

    default public Flux<ThreadListPart> getJoinedPrivateArchivedThreads() {
        return this.getRestChannel().getJoinedPrivateArchivedThreads().map(data -> new ThreadListPart(this.getClient(), (ListThreadsData)data));
    }
}

