/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.presence;

import discord4j.common.util.Snowflake;
import discord4j.core.object.reaction.ReactionEmoji;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.ActivityData;
import discord4j.discordjson.possible.Possible;
import java.time.Instant;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.Collectors;

public class Activity {
    private final ActivityData data;

    Activity(ActivityData data) {
        this.data = data;
    }

    public ActivityData getData() {
        return this.data;
    }

    public Type getType() {
        return Type.of(this.data.type());
    }

    public String getName() {
        if (this.getType() == Type.CUSTOM) {
            return Possible.flatOpt(this.data.state()).orElse("");
        }
        return this.data.name();
    }

    public Optional<String> getStreamingUrl() {
        return Possible.flatOpt(this.data.url());
    }

    public Instant getCreatedAt() {
        return Instant.ofEpochMilli(this.data.createdAt());
    }

    public Optional<Instant> getStart() {
        return this.data.timestamps().toOptional().flatMap(timestamps -> timestamps.start().toOptional()).map(Instant::ofEpochMilli);
    }

    public Optional<Instant> getEnd() {
        return this.data.timestamps().toOptional().flatMap(timestamps -> timestamps.end().toOptional()).map(Instant::ofEpochMilli);
    }

    public Optional<Snowflake> getApplicationId() {
        return this.data.applicationId().toOptional().map(Snowflake::of);
    }

    public Optional<String> getDetails() {
        return Possible.flatOpt(this.data.details());
    }

    public Optional<String> getState() {
        return Possible.flatOpt(this.data.state());
    }

    public Optional<String> getPartyId() {
        return this.data.party().toOptional().flatMap(party -> party.id().toOptional());
    }

    public OptionalLong getCurrentPartySize() {
        return this.data.party().toOptional().flatMap(party -> party.size().toOptional()).map(size -> (Long)size.get(0)).map(OptionalLong::of).orElseGet(OptionalLong::empty);
    }

    public OptionalLong getMaxPartySize() {
        return this.data.party().toOptional().flatMap(party -> party.size().toOptional()).map(size -> (Long)size.get(1)).map(OptionalLong::of).orElseGet(OptionalLong::empty);
    }

    public Optional<String> getLargeImageId() {
        return this.data.assets().toOptional().flatMap(assets -> assets.largeImage().toOptional());
    }

    public Optional<String> getLargeText() {
        return this.data.assets().toOptional().flatMap(assets -> assets.largeText().toOptional());
    }

    public Optional<String> getSmallImageId() {
        return this.data.assets().toOptional().flatMap(assets -> assets.smallImage().toOptional());
    }

    public Optional<String> getSmallText() {
        return this.data.assets().toOptional().flatMap(assets -> assets.smallText().toOptional());
    }

    public Optional<String> getJoinSecret() {
        return this.data.secrets().toOptional().flatMap(secrets -> secrets.join().toOptional());
    }

    public Optional<String> getSpectateSecret() {
        return this.data.secrets().toOptional().flatMap(secrets -> secrets.spectate().toOptional());
    }

    public Optional<String> getMatchSecret() {
        return this.data.secrets().toOptional().flatMap(secrets -> secrets.match().toOptional());
    }

    public Optional<ReactionEmoji> getEmoji() {
        return Possible.flatOpt(this.data.emoji()).map(emoji -> {
            String sid = emoji.id().toOptional().map(Id::asString).orElse(null);
            Long id = sid == null ? null : Long.valueOf(Snowflake.asLong(sid));
            return ReactionEmoji.of(id, emoji.name(), emoji.animated().toOptional().orElse(false));
        });
    }

    public boolean isInstance() {
        return this.data.instance().toOptional().orElse(false);
    }

    public EnumSet<Flag> getFlags() {
        return this.data.flags().toOptional().map(flags -> Arrays.stream(Flag.values()).filter(f -> (flags & f.getValue()) == f.getValue()).collect(Collectors.toCollection(() -> EnumSet.noneOf(Flag.class)))).orElse(EnumSet.noneOf(Flag.class));
    }

    public String toString() {
        return "Activity{data=" + this.data + '}';
    }

    public static enum Type {
        UNKNOWN(-1),
        PLAYING(0),
        STREAMING(1),
        LISTENING(2),
        WATCHING(3),
        CUSTOM(4),
        COMPETING(5);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Type of(int value) {
            switch (value) {
                case 0: {
                    return PLAYING;
                }
                case 1: {
                    return STREAMING;
                }
                case 2: {
                    return LISTENING;
                }
                case 3: {
                    return WATCHING;
                }
                case 4: {
                    return CUSTOM;
                }
                case 5: {
                    return COMPETING;
                }
            }
            return UNKNOWN;
        }
    }

    public static enum Flag {
        UNKNOWN(0),
        INSTANCE(1),
        JOIN(2),
        SPECTATE(4),
        JOIN_REQUEST(8),
        SYNC(16),
        PLAY(32),
        PARTY_PRIVACY_FRIENDS(64),
        PARTY_PRIVACY_VOICE_CHANNEL(128),
        EMBEDDED(256);

        private final int value;

        private Flag(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Flag of(int value) {
            switch (value) {
                case 1: {
                    return INSTANCE;
                }
                case 2: {
                    return JOIN;
                }
                case 4: {
                    return SPECTATE;
                }
                case 8: {
                    return JOIN_REQUEST;
                }
                case 16: {
                    return SYNC;
                }
                case 32: {
                    return PLAY;
                }
                case 64: {
                    return PARTY_PRIVACY_FRIENDS;
                }
                case 128: {
                    return PARTY_PRIVACY_VOICE_CHANNEL;
                }
                case 256: {
                    return EMBEDDED;
                }
            }
            return UNKNOWN;
        }
    }
}

