/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.presence;

import discord4j.core.object.presence.ClientActivity;
import discord4j.core.object.presence.Status;
import discord4j.discordjson.json.gateway.StatusUpdate;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import reactor.util.annotation.Nullable;

public class ClientPresence {
    private final StatusUpdate statusUpdate;

    public static ClientPresence online() {
        return ClientPresence.of(Status.ONLINE, null);
    }

    public static ClientPresence online(ClientActivity activity) {
        return ClientPresence.of(Status.ONLINE, activity);
    }

    public static ClientPresence doNotDisturb() {
        return ClientPresence.of(Status.DO_NOT_DISTURB, null);
    }

    public static ClientPresence doNotDisturb(ClientActivity activity) {
        return ClientPresence.of(Status.DO_NOT_DISTURB, activity);
    }

    public static ClientPresence idle() {
        return ClientPresence.of(Status.IDLE, null);
    }

    public static ClientPresence idle(ClientActivity activity) {
        return ClientPresence.of(Status.IDLE, activity);
    }

    public static ClientPresence invisible() {
        return ClientPresence.of(Status.INVISIBLE, null);
    }

    public static ClientPresence of(Status status, @Nullable ClientActivity activity) {
        List activities = Optional.ofNullable(activity).map(ClientActivity::getActivityUpdateRequest).map(Collections::singletonList).orElse(Collections.emptyList());
        return new ClientPresence(StatusUpdate.builder().status(status.getValue()).activities(activities).afk(false).since(0L).build());
    }

    private ClientPresence(StatusUpdate statusUpdate) {
        this.statusUpdate = statusUpdate;
    }

    public StatusUpdate getStatusUpdate() {
        return this.statusUpdate;
    }
}

