/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.retriever;

import discord4j.common.store.Store;
import discord4j.common.store.action.read.ReadActions;
import discord4j.common.store.api.object.ExactResultNotAvailableException;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.ScheduledEventUser;
import discord4j.core.object.automod.AutoModRule;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.GuildEmoji;
import discord4j.core.object.entity.GuildSticker;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.Role;
import discord4j.core.object.entity.ScheduledEvent;
import discord4j.core.object.entity.StageInstance;
import discord4j.core.object.entity.ThreadMember;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.object.entity.channel.GuildChannel;
import discord4j.core.retriever.EntityRetriever;
import discord4j.core.util.EntityUtil;
import discord4j.discordjson.json.AutoModRuleData;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.GuildData;
import discord4j.discordjson.json.GuildScheduledEventData;
import discord4j.discordjson.json.GuildScheduledEventUserData;
import discord4j.discordjson.json.MemberData;
import discord4j.discordjson.json.MessageData;
import discord4j.discordjson.json.RoleData;
import discord4j.discordjson.json.StageInstanceData;
import discord4j.discordjson.json.StickerData;
import discord4j.discordjson.json.ThreadMemberData;
import discord4j.discordjson.json.UserData;
import java.util.Collections;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class StoreEntityRetriever
implements EntityRetriever {
    private final GatewayDiscordClient gateway;
    private final Store store;

    public StoreEntityRetriever(GatewayDiscordClient gateway) {
        this.gateway = gateway;
        this.store = gateway.getGatewayResources().getStore();
    }

    @Override
    public Mono<Channel> getChannelById(Snowflake channelId) {
        return Mono.from(this.store.execute(ReadActions.getChannelById(channelId.asLong()))).map(data -> EntityUtil.getChannel(this.gateway, data));
    }

    @Override
    public Mono<Guild> getGuildById(Snowflake guildId) {
        return Mono.from(this.store.execute(ReadActions.getGuildById(guildId.asLong()))).map(data -> new Guild(this.gateway, (GuildData)data));
    }

    @Override
    public Mono<GuildSticker> getGuildStickerById(Snowflake guildId, Snowflake stickerId) {
        return Mono.from(this.store.execute(ReadActions.getStickerById(guildId.asLong(), stickerId.asLong()))).map(data -> new GuildSticker(this.gateway, (StickerData)data, guildId.asLong()));
    }

    @Override
    public Mono<GuildEmoji> getGuildEmojiById(Snowflake guildId, Snowflake emojiId) {
        return Mono.from(this.store.execute(ReadActions.getEmojiById(guildId.asLong(), emojiId.asLong()))).map(data -> new GuildEmoji(this.gateway, (EmojiData)data, guildId.asLong()));
    }

    @Override
    public Mono<Member> getMemberById(Snowflake guildId, Snowflake userId) {
        return Mono.from(this.store.execute(ReadActions.getMemberById(guildId.asLong(), userId.asLong()))).map(data -> new Member(this.gateway, (MemberData)data, guildId.asLong())).onErrorResume(ExactResultNotAvailableException.class, ignored -> this.gateway.requestMembers(guildId, Collections.singleton(userId)).filter(member -> member.getId().equals(userId)).next());
    }

    @Override
    public Mono<Message> getMessageById(Snowflake channelId, Snowflake messageId) {
        return Mono.from(this.store.execute(ReadActions.getMessageById(channelId.asLong(), messageId.asLong()))).map(data -> new Message(this.gateway, (MessageData)data));
    }

    @Override
    public Mono<Role> getRoleById(Snowflake guildId, Snowflake roleId) {
        return Mono.from(this.store.execute(ReadActions.getRoleById(guildId.asLong(), roleId.asLong()))).map(data -> new Role(this.gateway, (RoleData)data, guildId.asLong()));
    }

    @Override
    public Mono<User> getUserById(Snowflake userId) {
        return Mono.from(this.store.execute(ReadActions.getUserById(userId.asLong()))).map(data -> new User(this.gateway, (UserData)data));
    }

    @Override
    public Flux<Guild> getGuilds() {
        return Flux.from(this.store.execute(ReadActions.getGuilds())).map(data -> new Guild(this.gateway, (GuildData)data));
    }

    @Override
    public Mono<User> getSelf() {
        return this.getUserById(this.gateway.getSelfId());
    }

    @Override
    public Mono<Member> getSelfMember(Snowflake guildId) {
        return this.getMemberById(guildId, this.gateway.getSelfId());
    }

    @Override
    public Flux<Member> getGuildMembers(Snowflake guildId) {
        return Flux.from(this.store.execute(ReadActions.getExactMembersInGuild(guildId.asLong()))).map(data -> new Member(this.gateway, (MemberData)data, guildId.asLong())).onErrorResume(ExactResultNotAvailableException.class, e -> this.gateway.requestMembers(guildId));
    }

    @Override
    public Flux<GuildChannel> getGuildChannels(Snowflake guildId) {
        return Flux.from(this.store.execute(ReadActions.getChannelsInGuild(guildId.asLong()))).map(channelData -> EntityUtil.getChannel(this.gateway, channelData)).ofType(GuildChannel.class);
    }

    @Override
    public Flux<Role> getGuildRoles(Snowflake guildId) {
        return Flux.from(this.store.execute(ReadActions.getRolesInGuild(guildId.asLong()))).map(roleData -> new Role(this.gateway, (RoleData)roleData, guildId.asLong()));
    }

    @Override
    public Flux<GuildEmoji> getGuildEmojis(Snowflake guildId) {
        return Flux.from(this.store.execute(ReadActions.getEmojisInGuild(guildId.asLong()))).map(emojiData -> new GuildEmoji(this.gateway, (EmojiData)emojiData, guildId.asLong()));
    }

    @Override
    public Mono<StageInstance> getStageInstanceByChannelId(Snowflake channelId) {
        return Mono.from(this.store.execute(ReadActions.getStageInstanceByChannelId(channelId.asLong()))).map(data -> new StageInstance(this.gateway, (StageInstanceData)data));
    }

    @Override
    public Flux<GuildSticker> getGuildStickers(Snowflake guildId) {
        return Flux.from(this.store.execute(ReadActions.getStickersInGuild(guildId.asLong()))).map(data -> new GuildSticker(this.gateway, (StickerData)data, guildId.asLong()));
    }

    @Override
    public Mono<ThreadMember> getThreadMemberById(Snowflake threadId, Snowflake userId) {
        return Mono.from(this.store.execute(ReadActions.getThreadMemberById(threadId.asLong(), userId.asLong()))).map(data -> new ThreadMember(this.gateway, (ThreadMemberData)data));
    }

    @Override
    public Flux<ThreadMember> getThreadMembers(Snowflake threadId) {
        return Flux.from(this.store.execute(ReadActions.getMembersInThread(threadId.asLong()))).map(data -> new ThreadMember(this.gateway, (ThreadMemberData)data));
    }

    @Override
    public Flux<AutoModRule> getGuildAutoModRules(Snowflake guildId) {
        return Flux.from(this.store.execute(ReadActions.getAutoModRulesInGuild(guildId.asLong()))).map(data -> new AutoModRule(this.gateway, (AutoModRuleData)data));
    }

    @Override
    public Mono<ScheduledEvent> getScheduledEventById(Snowflake guildId, Snowflake eventId) {
        return Mono.from(this.store.execute(ReadActions.getScheduledEventById(guildId.asLong(), eventId.asLong()))).map(data -> new ScheduledEvent(this.gateway, (GuildScheduledEventData)data));
    }

    @Override
    public Flux<ScheduledEvent> getScheduledEvents(Snowflake guildId) {
        return Flux.from(this.store.execute(ReadActions.getScheduledEventsInGuild(guildId.asLong()))).map(data -> new ScheduledEvent(this.gateway, (GuildScheduledEventData)data));
    }

    @Override
    public Flux<ScheduledEventUser> getScheduledEventUsers(Snowflake guildId, Snowflake eventId) {
        return Flux.from(this.store.execute(ReadActions.getScheduledEventsUsers(guildId.asLong(), eventId.asLong()))).flatMap(id -> Mono.from(this.store.execute(ReadActions.getUserById(id.asLong())))).map(userData -> new ScheduledEventUser(this.gateway, GuildScheduledEventUserData.builder().user((UserData)userData).guildScheduledEventId(eventId.asLong()).build(), guildId));
    }
}

