/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.shard;

import discord4j.core.shard.GatewayClientGroupManager;
import discord4j.gateway.GatewayClient;
import discord4j.gateway.json.GatewayPayload;
import discord4j.gateway.json.ShardGatewayPayload;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class ShardingGatewayClientGroup
implements GatewayClientGroupManager {
    private final Map<Integer, GatewayClient> map = new ConcurrentHashMap<Integer, GatewayClient>();
    private final int shardCount;

    ShardingGatewayClientGroup(int shardCount) {
        this.shardCount = shardCount;
    }

    @Override
    public void add(int key, GatewayClient gatewayClient) {
        this.map.put(key, gatewayClient);
    }

    @Override
    public void remove(int key) {
        this.map.remove(key);
    }

    @Override
    public Optional<GatewayClient> find(int index) {
        return Optional.ofNullable(this.map.get(index));
    }

    @Override
    public int getShardCount() {
        return this.shardCount;
    }

    @Override
    public Mono<Void> multicast(GatewayPayload<?> payload) {
        return Flux.fromIterable(this.map.values()).flatMap(client -> client.send(Mono.just(payload))).then();
    }

    @Override
    public Mono<Void> unicast(ShardGatewayPayload<?> payload) {
        return Mono.justOrEmpty(this.find(payload.getShardIndex())).flatMap(client -> client.send(Mono.just(payload))).then();
    }

    @Override
    public Mono<Void> logout() {
        return Mono.whenDelayError(this.map.values().stream().map(client -> client.close(false)).collect(Collectors.toList()));
    }
}

