/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.common.util.Snowflake;
import discord4j.core.spec.ForumTagCreateSpecGenerator;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="ForumTagCreateSpecGenerator", generator="Immutables")
public final class ForumTagCreateSpec
implements ForumTagCreateSpecGenerator {
    private final String name;
    private final Boolean moderated_value;
    private final boolean moderated_absent;
    private final String emojiName_value;
    private final boolean emojiName_absent;
    private final Snowflake emojiId_value;
    private final boolean emojiId_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ForumTagCreateSpec(String name) {
        this.name = Objects.requireNonNull(name, "name");
        Possible moderated$impl = Possible.absent();
        Possible emojiName$impl = Possible.absent();
        Possible emojiId$impl = Possible.absent();
        this.moderated_value = moderated$impl.toOptional().orElse(null);
        this.moderated_absent = moderated$impl.isAbsent();
        this.emojiName_value = Possible.flatOpt(emojiName$impl).orElse(null);
        this.emojiName_absent = emojiName$impl.isAbsent();
        this.emojiId_value = Possible.flatOpt(emojiId$impl).orElse(null);
        this.emojiId_absent = emojiId$impl.isAbsent();
        this.initShim = null;
    }

    private ForumTagCreateSpec(String name, Possible<Boolean> moderated, Possible<Optional<String>> emojiName, Possible<Optional<Snowflake>> emojiId) {
        this.name = name;
        Possible<Boolean> moderated$impl = moderated;
        Possible emojiName$impl = emojiName;
        Possible emojiId$impl = emojiId;
        this.moderated_value = moderated$impl.toOptional().orElse(null);
        this.moderated_absent = moderated$impl.isAbsent();
        this.emojiName_value = Possible.flatOpt(emojiName$impl).orElse(null);
        this.emojiName_absent = emojiName$impl.isAbsent();
        this.emojiId_value = Possible.flatOpt(emojiId$impl).orElse(null);
        this.emojiId_absent = emojiId$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Possible<Boolean> moderated() {
        return this.moderated_absent ? Possible.absent() : Possible.of(this.moderated_value);
    }

    @Override
    public Possible<Optional<String>> emojiName() {
        return this.emojiName_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.emojiName_value));
    }

    @Override
    public Possible<Optional<Snowflake>> emojiId() {
        return this.emojiId_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.emojiId_value));
    }

    public final ForumTagCreateSpec withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ForumTagCreateSpec(newValue, this.moderated(), this.emojiName(), this.emojiId());
    }

    public ForumTagCreateSpec withModerated(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new ForumTagCreateSpec(this.name, newValue, this.emojiName(), this.emojiId());
    }

    public ForumTagCreateSpec withModerated(Boolean value) {
        Possible<Boolean> newValue = Possible.of(value);
        return new ForumTagCreateSpec(this.name, newValue, this.emojiName(), this.emojiId());
    }

    public ForumTagCreateSpec withEmojiName(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ForumTagCreateSpec(this.name, this.moderated(), newValue, this.emojiId());
    }

    @Deprecated
    public ForumTagCreateSpec withEmojiName(@Nullable String value) {
        Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
        return new ForumTagCreateSpec(this.name, this.moderated(), newValue, this.emojiId());
    }

    public ForumTagCreateSpec withEmojiNameOrNull(@Nullable String value) {
        Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
        return new ForumTagCreateSpec(this.name, this.moderated(), newValue, this.emojiId());
    }

    public ForumTagCreateSpec withEmojiId(Possible<Optional<Snowflake>> value) {
        Possible<Optional<Snowflake>> newValue = Objects.requireNonNull(value);
        return new ForumTagCreateSpec(this.name, this.moderated(), this.emojiName(), newValue);
    }

    @Deprecated
    public ForumTagCreateSpec withEmojiId(@Nullable Snowflake value) {
        Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
        return new ForumTagCreateSpec(this.name, this.moderated(), this.emojiName(), newValue);
    }

    public ForumTagCreateSpec withEmojiIdOrNull(@Nullable Snowflake value) {
        Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
        return new ForumTagCreateSpec(this.name, this.moderated(), this.emojiName(), newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ForumTagCreateSpec && this.equalTo(0, (ForumTagCreateSpec)another);
    }

    private boolean equalTo(int synthetic, ForumTagCreateSpec another) {
        return this.name.equals(another.name) && this.moderated().equals(another.moderated()) && this.emojiName().equals(another.emojiName()) && this.emojiId().equals(another.emojiId());
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + this.moderated().hashCode();
        h2 += (h2 << 5) + this.emojiName().hashCode();
        h2 += (h2 << 5) + this.emojiId().hashCode();
        return h2;
    }

    public String toString() {
        return "ForumTagCreateSpec{name=" + this.name + ", moderated=" + this.moderated().toString() + ", emojiName=" + this.emojiName().toString() + ", emojiId=" + this.emojiId().toString() + "}";
    }

    public static ForumTagCreateSpec of(String name) {
        return new ForumTagCreateSpec(name);
    }

    public static ForumTagCreateSpec copyOf(ForumTagCreateSpecGenerator instance) {
        if (instance instanceof ForumTagCreateSpec) {
            return (ForumTagCreateSpec)instance;
        }
        return ForumTagCreateSpec.builder().from(instance).build();
    }

    public boolean isModeratedPresent() {
        return !this.moderated_absent;
    }

    public Boolean moderatedOrElse(Boolean defaultValue) {
        return !this.moderated_absent ? this.moderated_value : defaultValue;
    }

    public boolean isEmojiNamePresent() {
        return !this.emojiName_absent;
    }

    public String emojiNameOrElse(String defaultValue) {
        return !this.emojiName_absent ? this.emojiName_value : defaultValue;
    }

    public boolean isEmojiIdPresent() {
        return !this.emojiId_absent;
    }

    public Snowflake emojiIdOrElse(Snowflake defaultValue) {
        return !this.emojiId_absent ? this.emojiId_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ForumTagCreateSpecGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build ForumTagCreateSpec, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="ForumTagCreateSpecGenerator", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private Possible<Boolean> moderated_possible = Possible.absent();
        private Possible<Optional<String>> emojiName_possible = Possible.absent();
        private Possible<Optional<Snowflake>> emojiId_possible = Possible.absent();
        private String name;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ForumTagCreateSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.moderated(instance.moderated());
            this.emojiName(instance.emojiName());
            this.emojiId(instance.emojiId());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder moderated(Possible<Boolean> value) {
            this.moderated_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder moderated(Boolean value) {
            this.moderated_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder emojiName(Possible<Optional<String>> value) {
            this.emojiName_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder emojiName(@Nullable String value) {
            this.emojiName_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder emojiNameOrNull(@Nullable String value) {
            this.emojiName_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder emojiId(Possible<Optional<Snowflake>> value) {
            this.emojiId_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder emojiId(@Nullable Snowflake value) {
            this.emojiId_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder emojiIdOrNull(@Nullable Snowflake value) {
            this.emojiId_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public ForumTagCreateSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ForumTagCreateSpec(this.name, this.moderated_build(), this.emojiName_build(), this.emojiId_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build ForumTagCreateSpec, some of required attributes are not set " + attributes;
        }

        private Possible<Boolean> moderated_build() {
            return this.moderated_possible;
        }

        private Possible<Optional<String>> emojiName_build() {
            return this.emojiName_possible;
        }

        private Possible<Optional<Snowflake>> emojiId_build() {
            return this.emojiId_possible;
        }
    }
}

