/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.common.util.Snowflake;
import discord4j.core.spec.GuildMemberEditSpecGenerator;
import discord4j.discordjson.possible.Possible;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="GuildMemberEditSpecGenerator", generator="Immutables")
public final class GuildMemberEditSpec
implements GuildMemberEditSpecGenerator {
    @Nullable
    private final String reason;
    private final Snowflake newVoiceChannel_value;
    private final boolean newVoiceChannel_absent;
    private final Boolean mute_value;
    private final boolean mute_absent;
    private final Boolean deafen_value;
    private final boolean deafen_absent;
    private final String nickname_value;
    private final boolean nickname_absent;
    private final List<Snowflake> roles_value;
    private final boolean roles_absent;
    private final Instant communicationDisabledUntil_value;
    private final boolean communicationDisabledUntil_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final GuildMemberEditSpec INSTANCE = GuildMemberEditSpec.validate(new GuildMemberEditSpec());

    private GuildMemberEditSpec() {
        this.reason = null;
        Possible newVoiceChannel$impl = Possible.absent();
        Possible mute$impl = Possible.absent();
        Possible deafen$impl = Possible.absent();
        Possible nickname$impl = Possible.absent();
        Possible roles$impl = Possible.absent();
        Possible communicationDisabledUntil$impl = Possible.absent();
        this.newVoiceChannel_value = Possible.flatOpt(newVoiceChannel$impl).orElse(null);
        this.newVoiceChannel_absent = newVoiceChannel$impl.isAbsent();
        this.mute_value = mute$impl.toOptional().orElse(null);
        this.mute_absent = mute$impl.isAbsent();
        this.deafen_value = deafen$impl.toOptional().orElse(null);
        this.deafen_absent = deafen$impl.isAbsent();
        this.nickname_value = Possible.flatOpt(nickname$impl).orElse(null);
        this.nickname_absent = nickname$impl.isAbsent();
        this.roles_value = roles$impl.toOptional().orElse(null);
        this.roles_absent = roles$impl.isAbsent();
        this.communicationDisabledUntil_value = Possible.flatOpt(communicationDisabledUntil$impl).orElse(null);
        this.communicationDisabledUntil_absent = communicationDisabledUntil$impl.isAbsent();
        this.initShim = null;
    }

    private GuildMemberEditSpec(@Nullable String reason, Possible<Optional<Snowflake>> newVoiceChannel, Possible<Boolean> mute, Possible<Boolean> deafen, Possible<Optional<String>> nickname, Possible<List<Snowflake>> roles, Possible<Optional<Instant>> communicationDisabledUntil) {
        this.reason = reason;
        Possible newVoiceChannel$impl = newVoiceChannel;
        Possible<Boolean> mute$impl = mute;
        Possible<Boolean> deafen$impl = deafen;
        Possible nickname$impl = nickname;
        Possible<List<Snowflake>> roles$impl = roles;
        Possible communicationDisabledUntil$impl = communicationDisabledUntil;
        this.newVoiceChannel_value = Possible.flatOpt(newVoiceChannel$impl).orElse(null);
        this.newVoiceChannel_absent = newVoiceChannel$impl.isAbsent();
        this.mute_value = mute$impl.toOptional().orElse(null);
        this.mute_absent = mute$impl.isAbsent();
        this.deafen_value = deafen$impl.toOptional().orElse(null);
        this.deafen_absent = deafen$impl.isAbsent();
        this.nickname_value = Possible.flatOpt(nickname$impl).orElse(null);
        this.nickname_absent = nickname$impl.isAbsent();
        this.roles_value = roles$impl.toOptional().orElse(null);
        this.roles_absent = roles$impl.isAbsent();
        this.communicationDisabledUntil_value = Possible.flatOpt(communicationDisabledUntil$impl).orElse(null);
        this.communicationDisabledUntil_absent = communicationDisabledUntil$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public Possible<Optional<Snowflake>> newVoiceChannel() {
        return this.newVoiceChannel_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.newVoiceChannel_value));
    }

    @Override
    public Possible<Boolean> mute() {
        return this.mute_absent ? Possible.absent() : Possible.of(this.mute_value);
    }

    @Override
    public Possible<Boolean> deafen() {
        return this.deafen_absent ? Possible.absent() : Possible.of(this.deafen_value);
    }

    @Override
    public Possible<Optional<String>> nickname() {
        return this.nickname_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.nickname_value));
    }

    @Override
    public Possible<List<Snowflake>> roles() {
        return this.roles_absent ? Possible.absent() : Possible.of(this.roles_value);
    }

    @Override
    public Possible<Optional<Instant>> communicationDisabledUntil() {
        return this.communicationDisabledUntil_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.communicationDisabledUntil_value));
    }

    public final GuildMemberEditSpec withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return GuildMemberEditSpec.validate(new GuildMemberEditSpec(value, this.newVoiceChannel(), this.mute(), this.deafen(), this.nickname(), this.roles(), this.communicationDisabledUntil()));
    }

    public GuildMemberEditSpec withNewVoiceChannel(Possible<Optional<Snowflake>> value) {
        Possible<Optional<Snowflake>> newValue = Objects.requireNonNull(value);
        return GuildMemberEditSpec.validate(new GuildMemberEditSpec(this.reason, newValue, this.mute(), this.deafen(), this.nickname(), this.roles(), this.communicationDisabledUntil()));
    }

    @Deprecated
    public GuildMemberEditSpec withNewVoiceChannel(@Nullable Snowflake value) {
        Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildMemberEditSpec.validate(new GuildMemberEditSpec(this.reason, newValue, this.mute(), this.deafen(), this.nickname(), this.roles(), this.communicationDisabledUntil()));
    }

    public GuildMemberEditSpec withNewVoiceChannelOrNull(@Nullable Snowflake value) {
        Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildMemberEditSpec.validate(new GuildMemberEditSpec(this.reason, newValue, this.mute(), this.deafen(), this.nickname(), this.roles(), this.communicationDisabledUntil()));
    }

    public GuildMemberEditSpec withMute(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return GuildMemberEditSpec.validate(new GuildMemberEditSpec(this.reason, this.newVoiceChannel(), newValue, this.deafen(), this.nickname(), this.roles(), this.communicationDisabledUntil()));
    }

    public GuildMemberEditSpec withMute(Boolean value) {
        Possible<Boolean> newValue = Possible.of(value);
        return GuildMemberEditSpec.validate(new GuildMemberEditSpec(this.reason, this.newVoiceChannel(), newValue, this.deafen(), this.nickname(), this.roles(), this.communicationDisabledUntil()));
    }

    public GuildMemberEditSpec withDeafen(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return GuildMemberEditSpec.validate(new GuildMemberEditSpec(this.reason, this.newVoiceChannel(), this.mute(), newValue, this.nickname(), this.roles(), this.communicationDisabledUntil()));
    }

    public GuildMemberEditSpec withDeafen(Boolean value) {
        Possible<Boolean> newValue = Possible.of(value);
        return GuildMemberEditSpec.validate(new GuildMemberEditSpec(this.reason, this.newVoiceChannel(), this.mute(), newValue, this.nickname(), this.roles(), this.communicationDisabledUntil()));
    }

    public GuildMemberEditSpec withNickname(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return GuildMemberEditSpec.validate(new GuildMemberEditSpec(this.reason, this.newVoiceChannel(), this.mute(), this.deafen(), newValue, this.roles(), this.communicationDisabledUntil()));
    }

    @Deprecated
    public GuildMemberEditSpec withNickname(@Nullable String value) {
        Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildMemberEditSpec.validate(new GuildMemberEditSpec(this.reason, this.newVoiceChannel(), this.mute(), this.deafen(), newValue, this.roles(), this.communicationDisabledUntil()));
    }

    public GuildMemberEditSpec withNicknameOrNull(@Nullable String value) {
        Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildMemberEditSpec.validate(new GuildMemberEditSpec(this.reason, this.newVoiceChannel(), this.mute(), this.deafen(), newValue, this.roles(), this.communicationDisabledUntil()));
    }

    public GuildMemberEditSpec withRoles(Possible<? extends List<? extends Snowflake>> possible) {
        Possible<List<Snowflake>> newValue = Objects.requireNonNull(possible);
        return GuildMemberEditSpec.validate(new GuildMemberEditSpec(this.reason, this.newVoiceChannel(), this.mute(), this.deafen(), this.nickname(), newValue, this.communicationDisabledUntil()));
    }

    public GuildMemberEditSpec withRoles(Iterable<? extends Snowflake> elements) {
        Possible<List<Snowflake>> newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return GuildMemberEditSpec.validate(new GuildMemberEditSpec(this.reason, this.newVoiceChannel(), this.mute(), this.deafen(), this.nickname(), newValue, this.communicationDisabledUntil()));
    }

    @SafeVarargs
    public final GuildMemberEditSpec withRoles(Snowflake ... elements) {
        Possible<List<Snowflake>> newValue = Possible.of(Arrays.asList(elements));
        return GuildMemberEditSpec.validate(new GuildMemberEditSpec(this.reason, this.newVoiceChannel(), this.mute(), this.deafen(), this.nickname(), newValue, this.communicationDisabledUntil()));
    }

    public GuildMemberEditSpec withCommunicationDisabledUntil(Possible<Optional<Instant>> value) {
        Possible<Optional<Instant>> newValue = Objects.requireNonNull(value);
        return GuildMemberEditSpec.validate(new GuildMemberEditSpec(this.reason, this.newVoiceChannel(), this.mute(), this.deafen(), this.nickname(), this.roles(), newValue));
    }

    @Deprecated
    public GuildMemberEditSpec withCommunicationDisabledUntil(@Nullable Instant value) {
        Possible<Optional<Instant>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildMemberEditSpec.validate(new GuildMemberEditSpec(this.reason, this.newVoiceChannel(), this.mute(), this.deafen(), this.nickname(), this.roles(), newValue));
    }

    public GuildMemberEditSpec withCommunicationDisabledUntilOrNull(@Nullable Instant value) {
        Possible<Optional<Instant>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildMemberEditSpec.validate(new GuildMemberEditSpec(this.reason, this.newVoiceChannel(), this.mute(), this.deafen(), this.nickname(), this.roles(), newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GuildMemberEditSpec && this.equalTo(0, (GuildMemberEditSpec)another);
    }

    private boolean equalTo(int synthetic, GuildMemberEditSpec another) {
        return Objects.equals(this.reason, another.reason) && this.newVoiceChannel().equals(another.newVoiceChannel()) && this.mute().equals(another.mute()) && this.deafen().equals(another.deafen()) && this.nickname().equals(another.nickname()) && Objects.equals(this.roles_value, another.roles_value) && this.communicationDisabledUntil().equals(another.communicationDisabledUntil());
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.reason);
        h2 += (h2 << 5) + this.newVoiceChannel().hashCode();
        h2 += (h2 << 5) + this.mute().hashCode();
        h2 += (h2 << 5) + this.deafen().hashCode();
        h2 += (h2 << 5) + this.nickname().hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.roles_value);
        h2 += (h2 << 5) + this.communicationDisabledUntil().hashCode();
        return h2;
    }

    public String toString() {
        return "GuildMemberEditSpec{reason=" + this.reason + ", newVoiceChannel=" + this.newVoiceChannel().toString() + ", mute=" + this.mute().toString() + ", deafen=" + this.deafen().toString() + ", nickname=" + this.nickname().toString() + ", roles=" + Objects.toString(this.roles_value) + ", communicationDisabledUntil=" + this.communicationDisabledUntil().toString() + "}";
    }

    public static GuildMemberEditSpec create() {
        return INSTANCE;
    }

    private static GuildMemberEditSpec validate(GuildMemberEditSpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    static GuildMemberEditSpec copyOf(GuildMemberEditSpecGenerator instance) {
        if (instance instanceof GuildMemberEditSpec) {
            return (GuildMemberEditSpec)instance;
        }
        return GuildMemberEditSpec.builder().from(instance).build();
    }

    public boolean isNewVoiceChannelPresent() {
        return !this.newVoiceChannel_absent;
    }

    public Snowflake newVoiceChannelOrElse(Snowflake defaultValue) {
        return !this.newVoiceChannel_absent ? this.newVoiceChannel_value : defaultValue;
    }

    public boolean isMutePresent() {
        return !this.mute_absent;
    }

    public Boolean muteOrElse(Boolean defaultValue) {
        return !this.mute_absent ? this.mute_value : defaultValue;
    }

    public boolean isDeafenPresent() {
        return !this.deafen_absent;
    }

    public Boolean deafenOrElse(Boolean defaultValue) {
        return !this.deafen_absent ? this.deafen_value : defaultValue;
    }

    public boolean isNicknamePresent() {
        return !this.nickname_absent;
    }

    public String nicknameOrElse(String defaultValue) {
        return !this.nickname_absent ? this.nickname_value : defaultValue;
    }

    public boolean isRolesPresent() {
        return !this.roles_absent;
    }

    public List<Snowflake> rolesOrElse(List<Snowflake> defaultValue) {
        return !this.roles_absent ? this.roles_value : defaultValue;
    }

    public boolean isCommunicationDisabledUntilPresent() {
        return !this.communicationDisabledUntil_absent;
    }

    public Instant communicationDisabledUntilOrElse(Instant defaultValue) {
        return !this.communicationDisabledUntil_absent ? this.communicationDisabledUntil_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GuildMemberEditSpecGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build GuildMemberEditSpec, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="GuildMemberEditSpecGenerator", generator="Immutables")
    public static final class Builder {
        private Possible<Optional<Snowflake>> newVoiceChannel_possible = Possible.absent();
        private Possible<Boolean> mute_possible = Possible.absent();
        private Possible<Boolean> deafen_possible = Possible.absent();
        private Possible<Optional<String>> nickname_possible = Possible.absent();
        private List<Snowflake> roles_list = null;
        private Possible<Optional<Instant>> communicationDisabledUntil_possible = Possible.absent();
        private String reason;

        private Builder() {
        }

        public final Builder from(GuildMemberEditSpec instance) {
            return this.from((GuildMemberEditSpecGenerator)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(GuildMemberEditSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            this.newVoiceChannel(instance.newVoiceChannel());
            this.mute(instance.mute());
            this.deafen(instance.deafen());
            this.nickname(instance.nickname());
            this.roles(instance.roles());
            this.communicationDisabledUntil(instance.communicationDisabledUntil());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reason(@Nullable String reason) {
            this.reason = reason;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder newVoiceChannel(Possible<Optional<Snowflake>> value) {
            this.newVoiceChannel_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder newVoiceChannel(@Nullable Snowflake value) {
            this.newVoiceChannel_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder newVoiceChannelOrNull(@Nullable Snowflake value) {
            this.newVoiceChannel_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder mute(Possible<Boolean> value) {
            this.mute_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder mute(Boolean value) {
            this.mute_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder deafen(Possible<Boolean> value) {
            this.deafen_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder deafen(Boolean value) {
            this.deafen_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder nickname(Possible<Optional<String>> value) {
            this.nickname_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder nickname(@Nullable String value) {
            this.nickname_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder nicknameOrNull(@Nullable String value) {
            this.nickname_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addRole(Snowflake element) {
            this.roles_getOrCreate().add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllRoles(Collection<? extends Snowflake> elements) {
            this.roles_getOrCreate().addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder roles(Possible<? extends Collection<? extends Snowflake>> elements) {
            this.roles_list = null;
            elements.toOptional().ifPresent(e -> this.roles_getOrCreate().addAll((Collection<Snowflake>)e));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder roles(Iterable<? extends Snowflake> elements) {
            this.roles_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder roles(Snowflake ... elements) {
            this.roles_list = Arrays.asList(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder communicationDisabledUntil(Possible<Optional<Instant>> value) {
            this.communicationDisabledUntil_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder communicationDisabledUntil(@Nullable Instant value) {
            this.communicationDisabledUntil_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder communicationDisabledUntilOrNull(@Nullable Instant value) {
            this.communicationDisabledUntil_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public GuildMemberEditSpec build() {
            return GuildMemberEditSpec.validate(new GuildMemberEditSpec(this.reason, this.newVoiceChannel_build(), this.mute_build(), this.deafen_build(), this.nickname_build(), this.roles_build(), this.communicationDisabledUntil_build()));
        }

        private Possible<Optional<Snowflake>> newVoiceChannel_build() {
            return this.newVoiceChannel_possible;
        }

        private Possible<Boolean> mute_build() {
            return this.mute_possible;
        }

        private Possible<Boolean> deafen_build() {
            return this.deafen_possible;
        }

        private Possible<Optional<String>> nickname_build() {
            return this.nickname_possible;
        }

        private Possible<List<Snowflake>> roles_build() {
            return this.roles_list == null ? Possible.absent() : Possible.of(this.roles_list);
        }

        private List<Snowflake> roles_getOrCreate() {
            if (this.roles_list == null) {
                this.roles_list = new ArrayList<Snowflake>();
            }
            return this.roles_list;
        }

        private Possible<Optional<Instant>> communicationDisabledUntil_build() {
            return this.communicationDisabledUntil_possible;
        }
    }
}

