/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.core.object.component.LayoutComponent;
import discord4j.core.spec.InteractionPresentModalSpecGenerator;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;

@Generated(from="InteractionPresentModalSpecGenerator", generator="Immutables")
public final class InteractionPresentModalSpec
implements InteractionPresentModalSpecGenerator {
    private final String title_value;
    private final boolean title_absent;
    private final String customId_value;
    private final boolean customId_absent;
    private final List<LayoutComponent> components_value;
    private final boolean components_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final InteractionPresentModalSpec INSTANCE = InteractionPresentModalSpec.validate(new InteractionPresentModalSpec());

    private InteractionPresentModalSpec() {
        Possible title$impl = Possible.absent();
        Possible customId$impl = Possible.absent();
        Possible components$impl = Possible.absent();
        this.title_value = title$impl.toOptional().orElse(null);
        this.title_absent = title$impl.isAbsent();
        this.customId_value = customId$impl.toOptional().orElse(null);
        this.customId_absent = customId$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.initShim = null;
    }

    private InteractionPresentModalSpec(Possible<String> title, Possible<String> customId, Possible<List<LayoutComponent>> components) {
        Possible<String> title$impl = title;
        Possible<String> customId$impl = customId;
        Possible<List<LayoutComponent>> components$impl = components;
        this.title_value = title$impl.toOptional().orElse(null);
        this.title_absent = title$impl.isAbsent();
        this.customId_value = customId$impl.toOptional().orElse(null);
        this.customId_absent = customId$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    public Possible<String> title() {
        return this.title_absent ? Possible.absent() : Possible.of(this.title_value);
    }

    @Override
    public Possible<String> customId() {
        return this.customId_absent ? Possible.absent() : Possible.of(this.customId_value);
    }

    @Override
    public Possible<List<LayoutComponent>> components() {
        return this.components_absent ? Possible.absent() : Possible.of(this.components_value);
    }

    public InteractionPresentModalSpec withTitle(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return InteractionPresentModalSpec.validate(new InteractionPresentModalSpec(newValue, this.customId(), this.components()));
    }

    public InteractionPresentModalSpec withTitle(String value) {
        Possible<String> newValue = Possible.of(value);
        return InteractionPresentModalSpec.validate(new InteractionPresentModalSpec(newValue, this.customId(), this.components()));
    }

    public InteractionPresentModalSpec withCustomId(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return InteractionPresentModalSpec.validate(new InteractionPresentModalSpec(this.title(), newValue, this.components()));
    }

    public InteractionPresentModalSpec withCustomId(String value) {
        Possible<String> newValue = Possible.of(value);
        return InteractionPresentModalSpec.validate(new InteractionPresentModalSpec(this.title(), newValue, this.components()));
    }

    public InteractionPresentModalSpec withComponents(Possible<? extends List<? extends LayoutComponent>> possible) {
        Possible<List<LayoutComponent>> newValue = Objects.requireNonNull(possible);
        return InteractionPresentModalSpec.validate(new InteractionPresentModalSpec(this.title(), this.customId(), newValue));
    }

    public InteractionPresentModalSpec withComponents(Iterable<? extends LayoutComponent> elements) {
        Possible<List<LayoutComponent>> newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return InteractionPresentModalSpec.validate(new InteractionPresentModalSpec(this.title(), this.customId(), newValue));
    }

    @SafeVarargs
    public final InteractionPresentModalSpec withComponents(LayoutComponent ... elements) {
        Possible<List<LayoutComponent>> newValue = Possible.of(Arrays.asList(elements));
        return InteractionPresentModalSpec.validate(new InteractionPresentModalSpec(this.title(), this.customId(), newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof InteractionPresentModalSpec && this.equalTo(0, (InteractionPresentModalSpec)another);
    }

    private boolean equalTo(int synthetic, InteractionPresentModalSpec another) {
        return this.title().equals(another.title()) && this.customId().equals(another.customId()) && Objects.equals(this.components_value, another.components_value);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.title().hashCode();
        h2 += (h2 << 5) + this.customId().hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.components_value);
        return h2;
    }

    public String toString() {
        return "InteractionPresentModalSpec{title=" + this.title().toString() + ", customId=" + this.customId().toString() + ", components=" + Objects.toString(this.components_value) + "}";
    }

    public static InteractionPresentModalSpec create() {
        return INSTANCE;
    }

    private static InteractionPresentModalSpec validate(InteractionPresentModalSpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    static InteractionPresentModalSpec copyOf(InteractionPresentModalSpecGenerator instance) {
        if (instance instanceof InteractionPresentModalSpec) {
            return (InteractionPresentModalSpec)instance;
        }
        return InteractionPresentModalSpec.builder().from(instance).build();
    }

    public boolean isTitlePresent() {
        return !this.title_absent;
    }

    public String titleOrElse(String defaultValue) {
        return !this.title_absent ? this.title_value : defaultValue;
    }

    public boolean isCustomIdPresent() {
        return !this.customId_absent;
    }

    public String customIdOrElse(String defaultValue) {
        return !this.customId_absent ? this.customId_value : defaultValue;
    }

    public boolean isComponentsPresent() {
        return !this.components_absent;
    }

    public List<LayoutComponent> componentsOrElse(List<LayoutComponent> defaultValue) {
        return !this.components_absent ? this.components_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="InteractionPresentModalSpecGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build InteractionPresentModalSpec, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="InteractionPresentModalSpecGenerator", generator="Immutables")
    public static final class Builder {
        private Possible<String> title_possible = Possible.absent();
        private Possible<String> customId_possible = Possible.absent();
        private List<LayoutComponent> components_list = null;

        private Builder() {
        }

        public final Builder from(InteractionPresentModalSpec instance) {
            return this.from((InteractionPresentModalSpecGenerator)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(InteractionPresentModalSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            this.title(instance.title());
            this.customId(instance.customId());
            this.components(instance.components());
            return this;
        }

        @CanIgnoreReturnValue
        public Builder title(Possible<String> value) {
            this.title_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder title(String value) {
            this.title_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder customId(Possible<String> value) {
            this.customId_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder customId(String value) {
            this.customId_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addComponent(LayoutComponent element) {
            this.components_getOrCreate().add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllComponents(Collection<? extends LayoutComponent> elements) {
            this.components_getOrCreate().addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder components(Possible<? extends Collection<? extends LayoutComponent>> elements) {
            this.components_list = null;
            elements.toOptional().ifPresent(e -> this.components_getOrCreate().addAll((Collection<LayoutComponent>)e));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder components(Iterable<? extends LayoutComponent> elements) {
            this.components_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder components(LayoutComponent ... elements) {
            this.components_list = Arrays.asList(elements);
            return this;
        }

        public InteractionPresentModalSpec build() {
            return InteractionPresentModalSpec.validate(new InteractionPresentModalSpec(this.title_build(), this.customId_build(), this.components_build()));
        }

        private Possible<String> title_build() {
            return this.title_possible;
        }

        private Possible<String> customId_build() {
            return this.customId_possible;
        }

        private Possible<List<LayoutComponent>> components_build() {
            return this.components_list == null ? Possible.absent() : Possible.of(this.components_list);
        }

        private List<LayoutComponent> components_getOrCreate() {
            if (this.components_list == null) {
                this.components_list = new ArrayList<LayoutComponent>();
            }
            return this.components_list;
        }
    }
}

