/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.PermissionOverwrite;
import discord4j.core.object.entity.Guild;
import discord4j.core.spec.StageChannelCreateMonoGenerator;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="StageChannelCreateMonoGenerator", generator="Immutables")
public final class StageChannelCreateMono
extends StageChannelCreateMonoGenerator {
    @Nullable
    private final String reason;
    private final String name;
    private final Integer bitrate_value;
    private final boolean bitrate_absent;
    private final Integer position_value;
    private final boolean position_absent;
    private final Integer rateLimitPerUser_value;
    private final boolean rateLimitPerUser_absent;
    private final List<PermissionOverwrite> permissionOverwrites_value;
    private final boolean permissionOverwrites_absent;
    private final Snowflake parentId_value;
    private final boolean parentId_absent;
    private final Guild guild;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private StageChannelCreateMono(String name, Guild guild) {
        this.name = Objects.requireNonNull(name, "name");
        this.guild = Objects.requireNonNull(guild, "guild");
        this.reason = null;
        Possible bitrate$impl = Possible.absent();
        Possible position$impl = Possible.absent();
        Possible rateLimitPerUser$impl = Possible.absent();
        Possible permissionOverwrites$impl = Possible.absent();
        Possible parentId$impl = Possible.absent();
        this.bitrate_value = bitrate$impl.toOptional().orElse(null);
        this.bitrate_absent = bitrate$impl.isAbsent();
        this.position_value = position$impl.toOptional().orElse(null);
        this.position_absent = position$impl.isAbsent();
        this.rateLimitPerUser_value = rateLimitPerUser$impl.toOptional().orElse(null);
        this.rateLimitPerUser_absent = rateLimitPerUser$impl.isAbsent();
        this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
        this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
        this.parentId_value = parentId$impl.toOptional().orElse(null);
        this.parentId_absent = parentId$impl.isAbsent();
        this.initShim = null;
    }

    private StageChannelCreateMono(@Nullable String reason, String name, Possible<Integer> bitrate, Possible<Integer> position, Possible<Integer> rateLimitPerUser, Possible<List<PermissionOverwrite>> permissionOverwrites, Possible<Snowflake> parentId, Guild guild) {
        this.reason = reason;
        this.name = name;
        Possible<Integer> bitrate$impl = bitrate;
        Possible<Integer> position$impl = position;
        Possible<Integer> rateLimitPerUser$impl = rateLimitPerUser;
        Possible<List<PermissionOverwrite>> permissionOverwrites$impl = permissionOverwrites;
        Possible<Snowflake> parentId$impl = parentId;
        this.guild = guild;
        this.bitrate_value = bitrate$impl.toOptional().orElse(null);
        this.bitrate_absent = bitrate$impl.isAbsent();
        this.position_value = position$impl.toOptional().orElse(null);
        this.position_absent = position$impl.isAbsent();
        this.rateLimitPerUser_value = rateLimitPerUser$impl.toOptional().orElse(null);
        this.rateLimitPerUser_absent = rateLimitPerUser$impl.isAbsent();
        this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
        this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
        this.parentId_value = parentId$impl.toOptional().orElse(null);
        this.parentId_absent = parentId$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Possible<Integer> bitrate() {
        return this.bitrate_absent ? Possible.absent() : Possible.of(this.bitrate_value);
    }

    @Override
    public Possible<Integer> position() {
        return this.position_absent ? Possible.absent() : Possible.of(this.position_value);
    }

    @Override
    public Possible<Integer> rateLimitPerUser() {
        return this.rateLimitPerUser_absent ? Possible.absent() : Possible.of(this.rateLimitPerUser_value);
    }

    @Override
    public Possible<List<PermissionOverwrite>> permissionOverwrites() {
        return this.permissionOverwrites_absent ? Possible.absent() : Possible.of(this.permissionOverwrites_value);
    }

    @Override
    public Possible<Snowflake> parentId() {
        return this.parentId_absent ? Possible.absent() : Possible.of(this.parentId_value);
    }

    @Override
    public Guild guild() {
        return this.guild;
    }

    public final StageChannelCreateMono withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new StageChannelCreateMono(value, this.name, this.bitrate(), this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId(), this.guild);
    }

    public final StageChannelCreateMono withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new StageChannelCreateMono(this.reason, newValue, this.bitrate(), this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId(), this.guild);
    }

    public StageChannelCreateMono withBitrate(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new StageChannelCreateMono(this.reason, this.name, newValue, this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId(), this.guild);
    }

    public StageChannelCreateMono withBitrate(Integer value) {
        Possible<Integer> newValue = Possible.of(value);
        return new StageChannelCreateMono(this.reason, this.name, newValue, this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId(), this.guild);
    }

    public StageChannelCreateMono withPosition(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new StageChannelCreateMono(this.reason, this.name, this.bitrate(), newValue, this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId(), this.guild);
    }

    public StageChannelCreateMono withPosition(Integer value) {
        Possible<Integer> newValue = Possible.of(value);
        return new StageChannelCreateMono(this.reason, this.name, this.bitrate(), newValue, this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId(), this.guild);
    }

    public StageChannelCreateMono withRateLimitPerUser(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new StageChannelCreateMono(this.reason, this.name, this.bitrate(), this.position(), newValue, this.permissionOverwrites(), this.parentId(), this.guild);
    }

    public StageChannelCreateMono withRateLimitPerUser(Integer value) {
        Possible<Integer> newValue = Possible.of(value);
        return new StageChannelCreateMono(this.reason, this.name, this.bitrate(), this.position(), newValue, this.permissionOverwrites(), this.parentId(), this.guild);
    }

    public StageChannelCreateMono withPermissionOverwrites(Possible<? extends List<? extends PermissionOverwrite>> possible) {
        Possible<List<PermissionOverwrite>> newValue = Objects.requireNonNull(possible);
        return new StageChannelCreateMono(this.reason, this.name, this.bitrate(), this.position(), this.rateLimitPerUser(), newValue, this.parentId(), this.guild);
    }

    public StageChannelCreateMono withPermissionOverwrites(Iterable<? extends PermissionOverwrite> elements) {
        Possible<List<PermissionOverwrite>> newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new StageChannelCreateMono(this.reason, this.name, this.bitrate(), this.position(), this.rateLimitPerUser(), newValue, this.parentId(), this.guild);
    }

    @SafeVarargs
    public final StageChannelCreateMono withPermissionOverwrites(PermissionOverwrite ... elements) {
        Possible<List<PermissionOverwrite>> newValue = Possible.of(Arrays.asList(elements));
        return new StageChannelCreateMono(this.reason, this.name, this.bitrate(), this.position(), this.rateLimitPerUser(), newValue, this.parentId(), this.guild);
    }

    public StageChannelCreateMono withParentId(Possible<Snowflake> value) {
        Possible<Snowflake> newValue = Objects.requireNonNull(value);
        return new StageChannelCreateMono(this.reason, this.name, this.bitrate(), this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), newValue, this.guild);
    }

    public StageChannelCreateMono withParentId(Snowflake value) {
        Possible<Snowflake> newValue = Possible.of(value);
        return new StageChannelCreateMono(this.reason, this.name, this.bitrate(), this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), newValue, this.guild);
    }

    public final StageChannelCreateMono withGuild(Guild value) {
        if (this.guild == value) {
            return this;
        }
        Guild newValue = Objects.requireNonNull(value, "guild");
        return new StageChannelCreateMono(this.reason, this.name, this.bitrate(), this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId(), newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof StageChannelCreateMono && this.equalTo(0, (StageChannelCreateMono)another);
    }

    private boolean equalTo(int synthetic, StageChannelCreateMono another) {
        return Objects.equals(this.reason, another.reason) && this.name.equals(another.name) && this.bitrate().equals(another.bitrate()) && this.position().equals(another.position()) && this.rateLimitPerUser().equals(another.rateLimitPerUser()) && Objects.equals(this.permissionOverwrites_value, another.permissionOverwrites_value) && this.parentId().equals(another.parentId()) && this.guild.equals(another.guild);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.reason);
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + this.bitrate().hashCode();
        h2 += (h2 << 5) + this.position().hashCode();
        h2 += (h2 << 5) + this.rateLimitPerUser().hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.permissionOverwrites_value);
        h2 += (h2 << 5) + this.parentId().hashCode();
        h2 += (h2 << 5) + this.guild.hashCode();
        return h2;
    }

    @Override
    public String toString() {
        return "StageChannelCreateMono{reason=" + this.reason + ", name=" + this.name + ", bitrate=" + this.bitrate().toString() + ", position=" + this.position().toString() + ", rateLimitPerUser=" + this.rateLimitPerUser().toString() + ", permissionOverwrites=" + Objects.toString(this.permissionOverwrites_value) + ", parentId=" + this.parentId().toString() + ", guild=" + this.guild + "}";
    }

    public static StageChannelCreateMono of(String name, Guild guild) {
        return new StageChannelCreateMono(name, guild);
    }

    static StageChannelCreateMono copyOf(StageChannelCreateMonoGenerator instance) {
        if (instance instanceof StageChannelCreateMono) {
            return (StageChannelCreateMono)instance;
        }
        return StageChannelCreateMono.of(instance.name(), instance.guild()).withReason(instance.reason()).withBitrate(instance.bitrate()).withPosition(instance.position()).withRateLimitPerUser(instance.rateLimitPerUser()).withPermissionOverwrites(instance.permissionOverwrites()).withParentId(instance.parentId());
    }

    public boolean isBitratePresent() {
        return !this.bitrate_absent;
    }

    public Integer bitrateOrElse(Integer defaultValue) {
        return !this.bitrate_absent ? this.bitrate_value : defaultValue;
    }

    public boolean isPositionPresent() {
        return !this.position_absent;
    }

    public Integer positionOrElse(Integer defaultValue) {
        return !this.position_absent ? this.position_value : defaultValue;
    }

    public boolean isRateLimitPerUserPresent() {
        return !this.rateLimitPerUser_absent;
    }

    public Integer rateLimitPerUserOrElse(Integer defaultValue) {
        return !this.rateLimitPerUser_absent ? this.rateLimitPerUser_value : defaultValue;
    }

    public boolean isPermissionOverwritesPresent() {
        return !this.permissionOverwrites_absent;
    }

    public List<PermissionOverwrite> permissionOverwritesOrElse(List<PermissionOverwrite> defaultValue) {
        return !this.permissionOverwrites_absent ? this.permissionOverwrites_value : defaultValue;
    }

    public boolean isParentIdPresent() {
        return !this.parentId_absent;
    }

    public Snowflake parentIdOrElse(Snowflake defaultValue) {
        return !this.parentId_absent ? this.parentId_value : defaultValue;
    }

    @Generated(from="StageChannelCreateMonoGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build StageChannelCreateMono, attribute initializers form cycle " + attributes;
        }
    }
}

