/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.channel.ThreadChannel;
import discord4j.core.spec.ForumThreadMessageCreateSpec;
import discord4j.core.spec.StartThreadInForumChannelSpecGenerator;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="StartThreadInForumChannelSpecGenerator", generator="Immutables")
public final class StartThreadInForumChannelSpec
implements StartThreadInForumChannelSpecGenerator {
    @Nullable
    private final String reason;
    private final String name;
    private final ForumThreadMessageCreateSpec message;
    private final ThreadChannel.AutoArchiveDuration autoArchiveDuration_value;
    private final boolean autoArchiveDuration_absent;
    private final Integer rateLimitPerUser_value;
    private final boolean rateLimitPerUser_absent;
    private final List<Snowflake> appliedTags_value;
    private final boolean appliedTags_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private StartThreadInForumChannelSpec(String name, ForumThreadMessageCreateSpec message) {
        this.name = Objects.requireNonNull(name, "name");
        this.message = Objects.requireNonNull(message, "message");
        this.reason = null;
        Possible autoArchiveDuration$impl = Possible.absent();
        Possible rateLimitPerUser$impl = Possible.absent();
        Possible appliedTags$impl = Possible.absent();
        this.autoArchiveDuration_value = autoArchiveDuration$impl.toOptional().orElse(null);
        this.autoArchiveDuration_absent = autoArchiveDuration$impl.isAbsent();
        this.rateLimitPerUser_value = Possible.flatOpt(rateLimitPerUser$impl).orElse(null);
        this.rateLimitPerUser_absent = rateLimitPerUser$impl.isAbsent();
        this.appliedTags_value = appliedTags$impl.toOptional().orElse(null);
        this.appliedTags_absent = appliedTags$impl.isAbsent();
        this.initShim = null;
    }

    private StartThreadInForumChannelSpec(@Nullable String reason, String name, ForumThreadMessageCreateSpec message, Possible<ThreadChannel.AutoArchiveDuration> autoArchiveDuration, Possible<Optional<Integer>> rateLimitPerUser, Possible<List<Snowflake>> appliedTags) {
        this.reason = reason;
        this.name = name;
        this.message = message;
        Possible<ThreadChannel.AutoArchiveDuration> autoArchiveDuration$impl = autoArchiveDuration;
        Possible rateLimitPerUser$impl = rateLimitPerUser;
        Possible<List<Snowflake>> appliedTags$impl = appliedTags;
        this.autoArchiveDuration_value = autoArchiveDuration$impl.toOptional().orElse(null);
        this.autoArchiveDuration_absent = autoArchiveDuration$impl.isAbsent();
        this.rateLimitPerUser_value = Possible.flatOpt(rateLimitPerUser$impl).orElse(null);
        this.rateLimitPerUser_absent = rateLimitPerUser$impl.isAbsent();
        this.appliedTags_value = appliedTags$impl.toOptional().orElse(null);
        this.appliedTags_absent = appliedTags$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ForumThreadMessageCreateSpec message() {
        return this.message;
    }

    @Override
    public Possible<ThreadChannel.AutoArchiveDuration> autoArchiveDuration() {
        return this.autoArchiveDuration_absent ? Possible.absent() : Possible.of(this.autoArchiveDuration_value);
    }

    @Override
    public Possible<Optional<Integer>> rateLimitPerUser() {
        return this.rateLimitPerUser_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.rateLimitPerUser_value));
    }

    @Override
    public Possible<List<Snowflake>> appliedTags() {
        return this.appliedTags_absent ? Possible.absent() : Possible.of(this.appliedTags_value);
    }

    public final StartThreadInForumChannelSpec withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new StartThreadInForumChannelSpec(value, this.name, this.message, this.autoArchiveDuration(), this.rateLimitPerUser(), this.appliedTags());
    }

    public final StartThreadInForumChannelSpec withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new StartThreadInForumChannelSpec(this.reason, newValue, this.message, this.autoArchiveDuration(), this.rateLimitPerUser(), this.appliedTags());
    }

    public final StartThreadInForumChannelSpec withMessage(ForumThreadMessageCreateSpec value) {
        if (this.message == value) {
            return this;
        }
        ForumThreadMessageCreateSpec newValue = Objects.requireNonNull(value, "message");
        return new StartThreadInForumChannelSpec(this.reason, this.name, newValue, this.autoArchiveDuration(), this.rateLimitPerUser(), this.appliedTags());
    }

    public StartThreadInForumChannelSpec withAutoArchiveDuration(Possible<ThreadChannel.AutoArchiveDuration> value) {
        Possible<ThreadChannel.AutoArchiveDuration> newValue = Objects.requireNonNull(value);
        return new StartThreadInForumChannelSpec(this.reason, this.name, this.message, newValue, this.rateLimitPerUser(), this.appliedTags());
    }

    public StartThreadInForumChannelSpec withAutoArchiveDuration(ThreadChannel.AutoArchiveDuration value) {
        Possible<ThreadChannel.AutoArchiveDuration> newValue = Possible.of(value);
        return new StartThreadInForumChannelSpec(this.reason, this.name, this.message, newValue, this.rateLimitPerUser(), this.appliedTags());
    }

    public StartThreadInForumChannelSpec withRateLimitPerUser(Possible<Optional<Integer>> value) {
        Possible<Optional<Integer>> newValue = Objects.requireNonNull(value);
        return new StartThreadInForumChannelSpec(this.reason, this.name, this.message, this.autoArchiveDuration(), newValue, this.appliedTags());
    }

    @Deprecated
    public StartThreadInForumChannelSpec withRateLimitPerUser(@Nullable Integer value) {
        Possible<Optional<Integer>> newValue = Possible.of(Optional.ofNullable(value));
        return new StartThreadInForumChannelSpec(this.reason, this.name, this.message, this.autoArchiveDuration(), newValue, this.appliedTags());
    }

    public StartThreadInForumChannelSpec withRateLimitPerUserOrNull(@Nullable Integer value) {
        Possible<Optional<Integer>> newValue = Possible.of(Optional.ofNullable(value));
        return new StartThreadInForumChannelSpec(this.reason, this.name, this.message, this.autoArchiveDuration(), newValue, this.appliedTags());
    }

    public StartThreadInForumChannelSpec withAppliedTags(Possible<? extends List<? extends Snowflake>> possible) {
        Possible<List<Snowflake>> newValue = Objects.requireNonNull(possible);
        return new StartThreadInForumChannelSpec(this.reason, this.name, this.message, this.autoArchiveDuration(), this.rateLimitPerUser(), newValue);
    }

    public StartThreadInForumChannelSpec withAppliedTags(Iterable<? extends Snowflake> elements) {
        Possible<List<Snowflake>> newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new StartThreadInForumChannelSpec(this.reason, this.name, this.message, this.autoArchiveDuration(), this.rateLimitPerUser(), newValue);
    }

    @SafeVarargs
    public final StartThreadInForumChannelSpec withAppliedTags(Snowflake ... elements) {
        Possible<List<Snowflake>> newValue = Possible.of(Arrays.asList(elements));
        return new StartThreadInForumChannelSpec(this.reason, this.name, this.message, this.autoArchiveDuration(), this.rateLimitPerUser(), newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof StartThreadInForumChannelSpec && this.equalTo(0, (StartThreadInForumChannelSpec)another);
    }

    private boolean equalTo(int synthetic, StartThreadInForumChannelSpec another) {
        return Objects.equals(this.reason, another.reason) && this.name.equals(another.name) && this.message.equals(another.message) && this.autoArchiveDuration().equals(another.autoArchiveDuration()) && this.rateLimitPerUser().equals(another.rateLimitPerUser()) && Objects.equals(this.appliedTags_value, another.appliedTags_value);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.reason);
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + this.message.hashCode();
        h2 += (h2 << 5) + this.autoArchiveDuration().hashCode();
        h2 += (h2 << 5) + this.rateLimitPerUser().hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.appliedTags_value);
        return h2;
    }

    public String toString() {
        return "StartThreadInForumChannelSpec{reason=" + this.reason + ", name=" + this.name + ", message=" + this.message + ", autoArchiveDuration=" + this.autoArchiveDuration().toString() + ", rateLimitPerUser=" + this.rateLimitPerUser().toString() + ", appliedTags=" + Objects.toString(this.appliedTags_value) + "}";
    }

    public static StartThreadInForumChannelSpec of(String name, ForumThreadMessageCreateSpec message) {
        return new StartThreadInForumChannelSpec(name, message);
    }

    public static StartThreadInForumChannelSpec copyOf(StartThreadInForumChannelSpecGenerator instance) {
        if (instance instanceof StartThreadInForumChannelSpec) {
            return (StartThreadInForumChannelSpec)instance;
        }
        return StartThreadInForumChannelSpec.builder().from(instance).build();
    }

    public boolean isAutoArchiveDurationPresent() {
        return !this.autoArchiveDuration_absent;
    }

    public ThreadChannel.AutoArchiveDuration autoArchiveDurationOrElse(ThreadChannel.AutoArchiveDuration defaultValue) {
        return !this.autoArchiveDuration_absent ? this.autoArchiveDuration_value : defaultValue;
    }

    public boolean isRateLimitPerUserPresent() {
        return !this.rateLimitPerUser_absent;
    }

    public Integer rateLimitPerUserOrElse(Integer defaultValue) {
        return !this.rateLimitPerUser_absent ? this.rateLimitPerUser_value : defaultValue;
    }

    public boolean isAppliedTagsPresent() {
        return !this.appliedTags_absent;
    }

    public List<Snowflake> appliedTagsOrElse(List<Snowflake> defaultValue) {
        return !this.appliedTags_absent ? this.appliedTags_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StartThreadInForumChannelSpecGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build StartThreadInForumChannelSpec, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="StartThreadInForumChannelSpecGenerator", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_MESSAGE = 2L;
        private long initBits = 3L;
        private Possible<ThreadChannel.AutoArchiveDuration> autoArchiveDuration_possible = Possible.absent();
        private Possible<Optional<Integer>> rateLimitPerUser_possible = Possible.absent();
        private List<Snowflake> appliedTags_list = null;
        private String reason;
        private String name;
        private ForumThreadMessageCreateSpec message;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StartThreadInForumChannelSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            this.name(instance.name());
            this.message(instance.message());
            this.autoArchiveDuration(instance.autoArchiveDuration());
            this.rateLimitPerUser(instance.rateLimitPerUser());
            this.appliedTags(instance.appliedTags());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reason(@Nullable String reason) {
            this.reason = reason;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder message(ForumThreadMessageCreateSpec message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder autoArchiveDuration(Possible<ThreadChannel.AutoArchiveDuration> value) {
            this.autoArchiveDuration_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder autoArchiveDuration(ThreadChannel.AutoArchiveDuration value) {
            this.autoArchiveDuration_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder rateLimitPerUser(Possible<Optional<Integer>> value) {
            this.rateLimitPerUser_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder rateLimitPerUser(@Nullable Integer value) {
            this.rateLimitPerUser_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder rateLimitPerUserOrNull(@Nullable Integer value) {
            this.rateLimitPerUser_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAppliedTag(Snowflake element) {
            this.appliedTags_getOrCreate().add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllAppliedTags(Collection<? extends Snowflake> elements) {
            this.appliedTags_getOrCreate().addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder appliedTags(Possible<? extends Collection<? extends Snowflake>> elements) {
            this.appliedTags_list = null;
            elements.toOptional().ifPresent(e -> this.appliedTags_getOrCreate().addAll((Collection<Snowflake>)e));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder appliedTags(Iterable<? extends Snowflake> elements) {
            this.appliedTags_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder appliedTags(Snowflake ... elements) {
            this.appliedTags_list = Arrays.asList(elements);
            return this;
        }

        public StartThreadInForumChannelSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new StartThreadInForumChannelSpec(this.reason, this.name, this.message, this.autoArchiveDuration_build(), this.rateLimitPerUser_build(), this.appliedTags_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("message");
            }
            return "Cannot build StartThreadInForumChannelSpec, some of required attributes are not set " + attributes;
        }

        private Possible<ThreadChannel.AutoArchiveDuration> autoArchiveDuration_build() {
            return this.autoArchiveDuration_possible;
        }

        private Possible<Optional<Integer>> rateLimitPerUser_build() {
            return this.rateLimitPerUser_possible;
        }

        private Possible<List<Snowflake>> appliedTags_build() {
            return this.appliedTags_list == null ? Possible.absent() : Possible.of(this.appliedTags_list);
        }

        private List<Snowflake> appliedTags_getOrCreate() {
            if (this.appliedTags_list == null) {
                this.appliedTags_list = new ArrayList<Snowflake>();
            }
            return this.appliedTags_list;
        }
    }
}

