/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.core.object.entity.channel.ThreadChannel;
import discord4j.core.spec.ThreadChannelEditSpecGenerator;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="ThreadChannelEditSpecGenerator", generator="Immutables")
public final class ThreadChannelEditSpec
implements ThreadChannelEditSpecGenerator {
    @Nullable
    private final String reason;
    private final String name_value;
    private final boolean name_absent;
    private final Integer rateLimitPerUser_value;
    private final boolean rateLimitPerUser_absent;
    private final Boolean archived_value;
    private final boolean archived_absent;
    private final ThreadChannel.AutoArchiveDuration autoArchiveDuration_value;
    private final boolean autoArchiveDuration_absent;
    private final Boolean locked_value;
    private final boolean locked_absent;
    private final Boolean invitable_value;
    private final boolean invitable_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ThreadChannelEditSpec INSTANCE = ThreadChannelEditSpec.validate(new ThreadChannelEditSpec());

    private ThreadChannelEditSpec() {
        this.reason = null;
        Possible name$impl = Possible.absent();
        Possible rateLimitPerUser$impl = Possible.absent();
        Possible archived$impl = Possible.absent();
        Possible autoArchiveDuration$impl = Possible.absent();
        Possible locked$impl = Possible.absent();
        Possible invitable$impl = Possible.absent();
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.rateLimitPerUser_value = rateLimitPerUser$impl.toOptional().orElse(null);
        this.rateLimitPerUser_absent = rateLimitPerUser$impl.isAbsent();
        this.archived_value = archived$impl.toOptional().orElse(null);
        this.archived_absent = archived$impl.isAbsent();
        this.autoArchiveDuration_value = autoArchiveDuration$impl.toOptional().orElse(null);
        this.autoArchiveDuration_absent = autoArchiveDuration$impl.isAbsent();
        this.locked_value = locked$impl.toOptional().orElse(null);
        this.locked_absent = locked$impl.isAbsent();
        this.invitable_value = invitable$impl.toOptional().orElse(null);
        this.invitable_absent = invitable$impl.isAbsent();
        this.initShim = null;
    }

    private ThreadChannelEditSpec(@Nullable String reason, Possible<String> name, Possible<Integer> rateLimitPerUser, Possible<Boolean> archived, Possible<ThreadChannel.AutoArchiveDuration> autoArchiveDuration, Possible<Boolean> locked, Possible<Boolean> invitable) {
        this.reason = reason;
        Possible<String> name$impl = name;
        Possible<Integer> rateLimitPerUser$impl = rateLimitPerUser;
        Possible<Boolean> archived$impl = archived;
        Possible<ThreadChannel.AutoArchiveDuration> autoArchiveDuration$impl = autoArchiveDuration;
        Possible<Boolean> locked$impl = locked;
        Possible<Boolean> invitable$impl = invitable;
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.rateLimitPerUser_value = rateLimitPerUser$impl.toOptional().orElse(null);
        this.rateLimitPerUser_absent = rateLimitPerUser$impl.isAbsent();
        this.archived_value = archived$impl.toOptional().orElse(null);
        this.archived_absent = archived$impl.isAbsent();
        this.autoArchiveDuration_value = autoArchiveDuration$impl.toOptional().orElse(null);
        this.autoArchiveDuration_absent = autoArchiveDuration$impl.isAbsent();
        this.locked_value = locked$impl.toOptional().orElse(null);
        this.locked_absent = locked$impl.isAbsent();
        this.invitable_value = invitable$impl.toOptional().orElse(null);
        this.invitable_absent = invitable$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public Possible<String> name() {
        return this.name_absent ? Possible.absent() : Possible.of(this.name_value);
    }

    @Override
    public Possible<Integer> rateLimitPerUser() {
        return this.rateLimitPerUser_absent ? Possible.absent() : Possible.of(this.rateLimitPerUser_value);
    }

    @Override
    public Possible<Boolean> archived() {
        return this.archived_absent ? Possible.absent() : Possible.of(this.archived_value);
    }

    @Override
    public Possible<ThreadChannel.AutoArchiveDuration> autoArchiveDuration() {
        return this.autoArchiveDuration_absent ? Possible.absent() : Possible.of(this.autoArchiveDuration_value);
    }

    @Override
    public Possible<Boolean> locked() {
        return this.locked_absent ? Possible.absent() : Possible.of(this.locked_value);
    }

    @Override
    public Possible<Boolean> invitable() {
        return this.invitable_absent ? Possible.absent() : Possible.of(this.invitable_value);
    }

    public final ThreadChannelEditSpec withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return ThreadChannelEditSpec.validate(new ThreadChannelEditSpec(value, this.name(), this.rateLimitPerUser(), this.archived(), this.autoArchiveDuration(), this.locked(), this.invitable()));
    }

    public ThreadChannelEditSpec withName(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return ThreadChannelEditSpec.validate(new ThreadChannelEditSpec(this.reason, newValue, this.rateLimitPerUser(), this.archived(), this.autoArchiveDuration(), this.locked(), this.invitable()));
    }

    public ThreadChannelEditSpec withName(String value) {
        Possible<String> newValue = Possible.of(value);
        return ThreadChannelEditSpec.validate(new ThreadChannelEditSpec(this.reason, newValue, this.rateLimitPerUser(), this.archived(), this.autoArchiveDuration(), this.locked(), this.invitable()));
    }

    public ThreadChannelEditSpec withRateLimitPerUser(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return ThreadChannelEditSpec.validate(new ThreadChannelEditSpec(this.reason, this.name(), newValue, this.archived(), this.autoArchiveDuration(), this.locked(), this.invitable()));
    }

    public ThreadChannelEditSpec withRateLimitPerUser(Integer value) {
        Possible<Integer> newValue = Possible.of(value);
        return ThreadChannelEditSpec.validate(new ThreadChannelEditSpec(this.reason, this.name(), newValue, this.archived(), this.autoArchiveDuration(), this.locked(), this.invitable()));
    }

    public ThreadChannelEditSpec withArchived(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return ThreadChannelEditSpec.validate(new ThreadChannelEditSpec(this.reason, this.name(), this.rateLimitPerUser(), newValue, this.autoArchiveDuration(), this.locked(), this.invitable()));
    }

    public ThreadChannelEditSpec withArchived(Boolean value) {
        Possible<Boolean> newValue = Possible.of(value);
        return ThreadChannelEditSpec.validate(new ThreadChannelEditSpec(this.reason, this.name(), this.rateLimitPerUser(), newValue, this.autoArchiveDuration(), this.locked(), this.invitable()));
    }

    public ThreadChannelEditSpec withAutoArchiveDuration(Possible<ThreadChannel.AutoArchiveDuration> value) {
        Possible<ThreadChannel.AutoArchiveDuration> newValue = Objects.requireNonNull(value);
        return ThreadChannelEditSpec.validate(new ThreadChannelEditSpec(this.reason, this.name(), this.rateLimitPerUser(), this.archived(), newValue, this.locked(), this.invitable()));
    }

    public ThreadChannelEditSpec withAutoArchiveDuration(ThreadChannel.AutoArchiveDuration value) {
        Possible<ThreadChannel.AutoArchiveDuration> newValue = Possible.of(value);
        return ThreadChannelEditSpec.validate(new ThreadChannelEditSpec(this.reason, this.name(), this.rateLimitPerUser(), this.archived(), newValue, this.locked(), this.invitable()));
    }

    public ThreadChannelEditSpec withLocked(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return ThreadChannelEditSpec.validate(new ThreadChannelEditSpec(this.reason, this.name(), this.rateLimitPerUser(), this.archived(), this.autoArchiveDuration(), newValue, this.invitable()));
    }

    public ThreadChannelEditSpec withLocked(Boolean value) {
        Possible<Boolean> newValue = Possible.of(value);
        return ThreadChannelEditSpec.validate(new ThreadChannelEditSpec(this.reason, this.name(), this.rateLimitPerUser(), this.archived(), this.autoArchiveDuration(), newValue, this.invitable()));
    }

    public ThreadChannelEditSpec withInvitable(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return ThreadChannelEditSpec.validate(new ThreadChannelEditSpec(this.reason, this.name(), this.rateLimitPerUser(), this.archived(), this.autoArchiveDuration(), this.locked(), newValue));
    }

    public ThreadChannelEditSpec withInvitable(Boolean value) {
        Possible<Boolean> newValue = Possible.of(value);
        return ThreadChannelEditSpec.validate(new ThreadChannelEditSpec(this.reason, this.name(), this.rateLimitPerUser(), this.archived(), this.autoArchiveDuration(), this.locked(), newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ThreadChannelEditSpec && this.equalTo(0, (ThreadChannelEditSpec)another);
    }

    private boolean equalTo(int synthetic, ThreadChannelEditSpec another) {
        return Objects.equals(this.reason, another.reason) && this.name().equals(another.name()) && this.rateLimitPerUser().equals(another.rateLimitPerUser()) && this.archived().equals(another.archived()) && this.autoArchiveDuration().equals(another.autoArchiveDuration()) && this.locked().equals(another.locked()) && this.invitable().equals(another.invitable());
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.reason);
        h2 += (h2 << 5) + this.name().hashCode();
        h2 += (h2 << 5) + this.rateLimitPerUser().hashCode();
        h2 += (h2 << 5) + this.archived().hashCode();
        h2 += (h2 << 5) + this.autoArchiveDuration().hashCode();
        h2 += (h2 << 5) + this.locked().hashCode();
        h2 += (h2 << 5) + this.invitable().hashCode();
        return h2;
    }

    public String toString() {
        return "ThreadChannelEditSpec{reason=" + this.reason + ", name=" + this.name().toString() + ", rateLimitPerUser=" + this.rateLimitPerUser().toString() + ", archived=" + this.archived().toString() + ", autoArchiveDuration=" + this.autoArchiveDuration().toString() + ", locked=" + this.locked().toString() + ", invitable=" + this.invitable().toString() + "}";
    }

    public static ThreadChannelEditSpec create() {
        return INSTANCE;
    }

    private static ThreadChannelEditSpec validate(ThreadChannelEditSpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    static ThreadChannelEditSpec copyOf(ThreadChannelEditSpecGenerator instance) {
        if (instance instanceof ThreadChannelEditSpec) {
            return (ThreadChannelEditSpec)instance;
        }
        return ThreadChannelEditSpec.builder().from(instance).build();
    }

    public boolean isNamePresent() {
        return !this.name_absent;
    }

    public String nameOrElse(String defaultValue) {
        return !this.name_absent ? this.name_value : defaultValue;
    }

    public boolean isRateLimitPerUserPresent() {
        return !this.rateLimitPerUser_absent;
    }

    public Integer rateLimitPerUserOrElse(Integer defaultValue) {
        return !this.rateLimitPerUser_absent ? this.rateLimitPerUser_value : defaultValue;
    }

    public boolean isArchivedPresent() {
        return !this.archived_absent;
    }

    public Boolean archivedOrElse(Boolean defaultValue) {
        return !this.archived_absent ? this.archived_value : defaultValue;
    }

    public boolean isAutoArchiveDurationPresent() {
        return !this.autoArchiveDuration_absent;
    }

    public ThreadChannel.AutoArchiveDuration autoArchiveDurationOrElse(ThreadChannel.AutoArchiveDuration defaultValue) {
        return !this.autoArchiveDuration_absent ? this.autoArchiveDuration_value : defaultValue;
    }

    public boolean isLockedPresent() {
        return !this.locked_absent;
    }

    public Boolean lockedOrElse(Boolean defaultValue) {
        return !this.locked_absent ? this.locked_value : defaultValue;
    }

    public boolean isInvitablePresent() {
        return !this.invitable_absent;
    }

    public Boolean invitableOrElse(Boolean defaultValue) {
        return !this.invitable_absent ? this.invitable_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ThreadChannelEditSpecGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build ThreadChannelEditSpec, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="ThreadChannelEditSpecGenerator", generator="Immutables")
    public static final class Builder {
        private Possible<String> name_possible = Possible.absent();
        private Possible<Integer> rateLimitPerUser_possible = Possible.absent();
        private Possible<Boolean> archived_possible = Possible.absent();
        private Possible<ThreadChannel.AutoArchiveDuration> autoArchiveDuration_possible = Possible.absent();
        private Possible<Boolean> locked_possible = Possible.absent();
        private Possible<Boolean> invitable_possible = Possible.absent();
        private String reason;

        private Builder() {
        }

        public final Builder from(ThreadChannelEditSpec instance) {
            return this.from((ThreadChannelEditSpecGenerator)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(ThreadChannelEditSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            this.name(instance.name());
            this.rateLimitPerUser(instance.rateLimitPerUser());
            this.archived(instance.archived());
            this.autoArchiveDuration(instance.autoArchiveDuration());
            this.locked(instance.locked());
            this.invitable(instance.invitable());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reason(@Nullable String reason) {
            this.reason = reason;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder name(Possible<String> value) {
            this.name_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder name(String value) {
            this.name_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder rateLimitPerUser(Possible<Integer> value) {
            this.rateLimitPerUser_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder rateLimitPerUser(Integer value) {
            this.rateLimitPerUser_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder archived(Possible<Boolean> value) {
            this.archived_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder archived(Boolean value) {
            this.archived_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder autoArchiveDuration(Possible<ThreadChannel.AutoArchiveDuration> value) {
            this.autoArchiveDuration_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder autoArchiveDuration(ThreadChannel.AutoArchiveDuration value) {
            this.autoArchiveDuration_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder locked(Possible<Boolean> value) {
            this.locked_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder locked(Boolean value) {
            this.locked_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder invitable(Possible<Boolean> value) {
            this.invitable_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder invitable(Boolean value) {
            this.invitable_possible = Possible.of(value);
            return this;
        }

        public ThreadChannelEditSpec build() {
            return ThreadChannelEditSpec.validate(new ThreadChannelEditSpec(this.reason, this.name_build(), this.rateLimitPerUser_build(), this.archived_build(), this.autoArchiveDuration_build(), this.locked_build(), this.invitable_build()));
        }

        private Possible<String> name_build() {
            return this.name_possible;
        }

        private Possible<Integer> rateLimitPerUser_build() {
            return this.rateLimitPerUser_possible;
        }

        private Possible<Boolean> archived_build() {
            return this.archived_possible;
        }

        private Possible<ThreadChannel.AutoArchiveDuration> autoArchiveDuration_build() {
            return this.autoArchiveDuration_possible;
        }

        private Possible<Boolean> locked_build() {
            return this.locked_possible;
        }

        private Possible<Boolean> invitable_build() {
            return this.invitable_possible;
        }
    }
}

