/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.PermissionOverwrite;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.spec.AuditSpec;
import discord4j.core.spec.InternalSpecUtils;
import discord4j.discordjson.json.ChannelCreateRequest;
import discord4j.discordjson.possible.Possible;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@Value.Immutable
interface VoiceChannelCreateSpecGenerator
extends AuditSpec<ChannelCreateRequest> {
    public String name();

    public Possible<Integer> bitrate();

    public Possible<Integer> userLimit();

    public Possible<Integer> position();

    public Possible<Integer> rateLimitPerUser();

    public Possible<List<PermissionOverwrite>> permissionOverwrites();

    public Possible<Snowflake> parentId();

    @Override
    default public ChannelCreateRequest asRequest() {
        return ChannelCreateRequest.builder().type(Channel.Type.GUILD_VOICE.getValue()).name(this.name()).bitrate(this.bitrate()).userLimit(this.userLimit()).position(this.position()).rateLimitPerUser(this.rateLimitPerUser()).permissionOverwrites(InternalSpecUtils.mapPossible(this.permissionOverwrites(), po -> po.stream().map(PermissionOverwrite::getData).collect(Collectors.toList()))).parentId(InternalSpecUtils.mapPossible(this.parentId(), Snowflake::asString)).build();
    }
}

