/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.interaction;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import discord4j.common.annotations.Experimental;
import discord4j.common.util.Snowflake;
import discord4j.discordjson.json.ApplicationCommandInteractionData;
import discord4j.discordjson.json.ApplicationCommandRequest;
import discord4j.discordjson.json.InteractionData;
import discord4j.discordjson.json.InteractionResponseData;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.RestClient;
import discord4j.rest.interaction.ApplicationCommandDefinition;
import discord4j.rest.interaction.DirectInteraction;
import discord4j.rest.interaction.GuildInteraction;
import discord4j.rest.interaction.InteractionHandler;
import discord4j.rest.interaction.InteractionHandlerSpec;
import discord4j.rest.interaction.InteractionOperations;
import discord4j.rest.interaction.InteractionResponse;
import discord4j.rest.interaction.InteractionValidator;
import discord4j.rest.interaction.RestInteraction;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.function.TupleUtils;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import reactor.util.Logger;
import reactor.util.Loggers;

@Experimental
public class Interactions {
    private static final Logger log = Loggers.getLogger(Interactions.class);
    private final List<ApplicationCommandDefinition> commands = new CopyOnWriteArrayList<ApplicationCommandDefinition>();
    private final List<ApplicationCommandRequestDefinition> createRequests = new CopyOnWriteArrayList<ApplicationCommandRequestDefinition>();
    static ApplicationCommandDefinition NOOP_DEF = new ApplicationCommandDefinition(){

        @Override
        public boolean test(ApplicationCommandInteractionData acid) {
            return true;
        }

        @Override
        public InteractionHandler createResponseHandler(RestInteraction interaction) {
            return NOOP_HANDLER_FUNCTION.apply(interaction);
        }
    };
    static Function<RestInteraction, InteractionHandler> NOOP_HANDLER_FUNCTION = it -> new InteractionHandler((RestInteraction)it){
        final /* synthetic */ RestInteraction val$it;
        {
            this.val$it = restInteraction;
        }

        @Override
        public InteractionResponseData response() {
            return this.val$it.acknowledge().response();
        }

        @Override
        public Publisher<?> onInteractionResponse(InteractionResponse response) {
            return Mono.empty();
        }
    };

    public static Interactions create() {
        return new Interactions();
    }

    Interactions() {
    }

    public Interactions onCommand(Snowflake id, Function<RestInteraction, InteractionHandler> action) {
        this.commands.add(new RequestApplicationCommandDefinition(acid -> acid.id().equals(Possible.of(id.asString())), action));
        return this;
    }

    public Interactions onCommand(String name, Function<RestInteraction, InteractionHandler> action) {
        this.commands.add(new RequestApplicationCommandDefinition(acid -> acid.name().equals(Possible.of(name)), action));
        return this;
    }

    public Interactions onGuildCommand(ApplicationCommandRequest createRequest, Snowflake guildId, Function<GuildInteraction, InteractionHandler> action) {
        this.commands.add(new GuildApplicationCommandDefinition(acid -> acid.name().equals(Possible.of(createRequest.name())), action));
        this.createRequests.add(new GuildApplicationCommandRequest(createRequest, guildId));
        return this;
    }

    public Interactions onGlobalCommand(ApplicationCommandRequest createRequest, Function<RestInteraction, InteractionHandler> action) {
        this.commands.add(new RequestApplicationCommandDefinition(acid -> acid.name().equals(Possible.of(createRequest.name())), action));
        this.createRequests.add(new GlobalApplicationCommandRequest(createRequest));
        return this;
    }

    public Mono<Void> createCommands(RestClient restClient) {
        Mono<Long> appIdMono = restClient.getApplicationId();
        return Flux.fromIterable(this.createRequests).zipWith(appIdMono.repeat()).flatMap(TupleUtils.function((req, appId) -> {
            if (req instanceof GuildApplicationCommandRequest) {
                GuildApplicationCommandRequest guildCommandRequest = (GuildApplicationCommandRequest)req;
                return restClient.getApplicationService().createGuildApplicationCommand((long)appId, guildCommandRequest.getGuild(), req.getRequest()).doOnError(e -> log.warn("Unable to create guild command", (Throwable)e)).onErrorResume(e -> Mono.empty());
            }
            return restClient.getApplicationService().createGlobalApplicationCommand((long)appId, req.getRequest()).doOnError(e -> log.warn("Unable to create global command", (Throwable)e)).onErrorResume(e -> Mono.empty());
        })).then();
    }

    public ApplicationCommandDefinition findHandler(InteractionData interactionData) {
        return interactionData.data().toOptional().flatMap(acid -> this.commands.stream().filter(it -> it.test((ApplicationCommandInteractionData)acid)).findFirst()).orElse(NOOP_DEF);
    }

    public ReactorNettyServerHandler buildReactorNettyHandler(RestClient restClient) {
        return this.buildReactorNettyHandler(restClient, new NoopInteractionValidator());
    }

    public ReactorNettyServerHandler buildReactorNettyHandler(RestClient restClient, InteractionValidator interactionValidator) {
        return (serverRequest, serverResponse) -> serverRequest.receive().aggregate().asString().flatMap(body -> {
            String timestamp;
            String signature = serverRequest.requestHeaders().get("X-Signature-Ed25519");
            if (interactionValidator.validateSignature(signature, timestamp = serverRequest.requestHeaders().get("X-Signature-Timestamp"), (String)body)) {
                return this.handleValidated((String)body, (HttpServerResponse)serverResponse, restClient);
            }
            return serverResponse.status(HttpResponseStatus.UNAUTHORIZED).send();
        });
    }

    private Mono<Void> handleValidated(String body, HttpServerResponse serverResponse, RestClient restClient) {
        ObjectMapper mapper = restClient.getRestResources().getJacksonResources().getObjectMapper();
        return Mono.fromCallable(() -> mapper.readValue(body, JsonNode.class)).flatMap(node -> {
            int type = node.get("type").asInt();
            if (type == 1) {
                return serverResponse.addHeader("content-type", "application/json").chunkedTransfer(false).sendString(Mono.just("{\"type\":1}")).then();
            }
            if (type == 2) {
                InteractionData interactionData = mapper.convertValue(node, InteractionData.class);
                InteractionOperations ops = new InteractionOperations(restClient, interactionData);
                InteractionHandler handler = this.findHandler(interactionData).createResponseHandler(ops);
                Scheduler timedScheduler = restClient.getRestResources().getReactorResources().getTimerTaskScheduler();
                Scheduler blockScheduler = restClient.getRestResources().getReactorResources().getBlockingTaskScheduler();
                return serverResponse.addHeader("content-type", "application/json").chunkedTransfer(false).sendString(Mono.fromCallable(() -> mapper.writeValueAsString(handler.response()))).then().doFinally(s2 -> Flux.from(handler.onInteractionResponse(ops)).take(Duration.ofMinutes(15L), timedScheduler).subscribeOn(blockScheduler).subscribe(null, e -> log.error("Followup handler error", (Throwable)e), () -> log.info("Followup handler done")));
            }
            return serverResponse.sendNotFound();
        }).then();
    }

    public static Function<RestInteraction, InteractionHandler> guild(Function<GuildInteraction, InteractionHandler> handlerFunction) {
        return new InteractionHandlerSpec(handlerFunction, it -> NOOP_HANDLER_FUNCTION.apply((RestInteraction)it)).build();
    }

    public static Function<RestInteraction, InteractionHandler> direct(Function<DirectInteraction, InteractionHandler> handlerFunction) {
        return new InteractionHandlerSpec(it -> NOOP_HANDLER_FUNCTION.apply((RestInteraction)it), handlerFunction).build();
    }

    public static InteractionHandlerSpec createHandler() {
        return new InteractionHandlerSpec(it -> NOOP_HANDLER_FUNCTION.apply((RestInteraction)it), it -> NOOP_HANDLER_FUNCTION.apply((RestInteraction)it));
    }

    static class RequestApplicationCommandDefinition
    implements ApplicationCommandDefinition {
        private final Predicate<ApplicationCommandInteractionData> matcher;
        private final Function<RestInteraction, InteractionHandler> action;

        public RequestApplicationCommandDefinition(Predicate<ApplicationCommandInteractionData> matcher, Function<RestInteraction, InteractionHandler> action) {
            this.matcher = matcher;
            this.action = action;
        }

        @Override
        public boolean test(ApplicationCommandInteractionData acid) {
            return this.matcher.test(acid);
        }

        @Override
        public InteractionHandler createResponseHandler(RestInteraction interaction) {
            return this.action.apply(interaction);
        }
    }

    static class GuildApplicationCommandDefinition
    implements ApplicationCommandDefinition {
        private final Predicate<ApplicationCommandInteractionData> matcher;
        private final Function<GuildInteraction, InteractionHandler> action;

        public GuildApplicationCommandDefinition(Predicate<ApplicationCommandInteractionData> matcher, Function<GuildInteraction, InteractionHandler> action) {
            this.matcher = matcher;
            this.action = action;
        }

        @Override
        public boolean test(ApplicationCommandInteractionData acid) {
            return this.matcher.test(acid);
        }

        @Override
        public InteractionHandler createResponseHandler(RestInteraction interaction) {
            return this.action.apply((GuildInteraction)interaction);
        }
    }

    static class GuildApplicationCommandRequest
    implements ApplicationCommandRequestDefinition {
        private final ApplicationCommandRequest request;
        private final long guild;

        public GuildApplicationCommandRequest(ApplicationCommandRequest request, Snowflake guild) {
            this.request = request;
            this.guild = guild.asLong();
        }

        @Override
        public ApplicationCommandRequest getRequest() {
            return this.request;
        }

        public long getGuild() {
            return this.guild;
        }
    }

    static class GlobalApplicationCommandRequest
    implements ApplicationCommandRequestDefinition {
        private final ApplicationCommandRequest request;

        public GlobalApplicationCommandRequest(ApplicationCommandRequest request) {
            this.request = request;
        }

        @Override
        public ApplicationCommandRequest getRequest() {
            return this.request;
        }
    }

    private static class NoopInteractionValidator
    implements InteractionValidator {
        private NoopInteractionValidator() {
        }

        @Override
        public boolean validateSignature(String body, String signature, String timestamp) {
            return true;
        }
    }

    public static interface ReactorNettyServerHandler
    extends BiFunction<HttpServerRequest, HttpServerResponse, Publisher<Void>> {
    }

    static interface ApplicationCommandRequestDefinition {
        public ApplicationCommandRequest getRequest();
    }
}

