/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.response;

import discord4j.common.annotations.Experimental;
import discord4j.rest.http.client.ClientException;
import discord4j.rest.http.client.ClientResponse;
import discord4j.rest.request.DiscordWebRequest;
import discord4j.rest.request.RouteMatcher;
import discord4j.rest.response.EmptyResponseTransformer;
import discord4j.rest.response.RetryingTransformer;
import java.time.Duration;
import java.util.function.Function;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;
import reactor.util.retry.RetryBackoffSpec;

@Experimental
public interface ResponseFunction {
    public Function<Mono<ClientResponse>, Mono<ClientResponse>> transform(DiscordWebRequest var1);

    public static EmptyResponseTransformer emptyIfNotFound() {
        return new EmptyResponseTransformer(RouteMatcher.any(), ClientException.isStatusCode(404));
    }

    public static EmptyResponseTransformer emptyIfNotFound(RouteMatcher routeMatcher) {
        return new EmptyResponseTransformer(routeMatcher, ClientException.isStatusCode(404));
    }

    public static EmptyResponseTransformer emptyOnErrorStatus(RouteMatcher routeMatcher, Integer ... codes) {
        return new EmptyResponseTransformer(routeMatcher, ClientException.isStatusCode(codes));
    }

    public static RetryingTransformer retryOnceOnErrorStatus(Integer ... codes) {
        return new RetryingTransformer(RouteMatcher.any(), RetryBackoffSpec.backoff(1L, Duration.ofSeconds(1L)).filter(exception -> ClientException.isStatusCode(codes).test((Throwable)exception)));
    }

    public static RetryingTransformer retryOnceOnErrorStatus(RouteMatcher routeMatcher, Integer ... codes) {
        return new RetryingTransformer(routeMatcher, RetryBackoffSpec.backoff(1L, Duration.ofSeconds(1L)).filter(exception -> ClientException.isStatusCode(codes).test((Throwable)exception)));
    }

    public static RetryingTransformer retryWhen(RouteMatcher routeMatcher, Retry retry) {
        return new RetryingTransformer(routeMatcher, retry);
    }
}

