/*
 * Decompiled with CFR 0.152.
 */
package discord4j.common.sinks;

import discord4j.common.sinks.EmissionStrategy;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Supplier;
import reactor.core.publisher.Sinks;

class ParkEmissionStrategy
implements EmissionStrategy {
    private final long parkNanos;

    ParkEmissionStrategy(long parkNanos) {
        this.parkNanos = parkNanos;
    }

    @Override
    public <T> boolean emitNext(Sinks.Many<T> sink, T element) {
        Sinks.EmitResult emission;
        block5: while (true) {
            if ((emission = sink.tryEmitNext(element)).isSuccess()) {
                return true;
            }
            switch (emission) {
                case FAIL_ZERO_SUBSCRIBER: 
                case FAIL_CANCELLED: 
                case FAIL_TERMINATED: {
                    return false;
                }
                case FAIL_NON_SERIALIZED: {
                    continue block5;
                }
                case FAIL_OVERFLOW: {
                    LockSupport.parkNanos(this.parkNanos);
                    continue block5;
                }
            }
            break;
        }
        throw new Sinks.EmissionException(emission, "Unknown emitResult value");
    }

    @Override
    public <T> boolean emitComplete(Sinks.Many<T> sink) {
        return this.emitTerminal(sink::tryEmitComplete);
    }

    @Override
    public <T> boolean emitError(Sinks.Many<T> sink, Throwable error) {
        return this.emitTerminal(() -> sink.tryEmitError(error));
    }

    private <T> boolean emitTerminal(Supplier<Sinks.EmitResult> resultSupplier) {
        Sinks.EmitResult emission;
        block4: while (true) {
            if ((emission = resultSupplier.get()).isSuccess()) {
                return true;
            }
            switch (emission) {
                case FAIL_ZERO_SUBSCRIBER: 
                case FAIL_CANCELLED: 
                case FAIL_TERMINATED: 
                case FAIL_OVERFLOW: {
                    return false;
                }
                case FAIL_NON_SERIALIZED: {
                    LockSupport.parkNanos(this.parkNanos);
                    continue block4;
                }
            }
            break;
        }
        throw new Sinks.EmissionException(emission, "Unknown emitResult value");
    }
}

