/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.dispatch;

import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.dispatch.DispatchContext;
import discord4j.core.event.domain.Event;
import discord4j.core.event.domain.thread.ThreadChannelCreateEvent;
import discord4j.core.event.domain.thread.ThreadChannelDeleteEvent;
import discord4j.core.event.domain.thread.ThreadChannelUpdateEvent;
import discord4j.core.event.domain.thread.ThreadListSyncEvent;
import discord4j.core.event.domain.thread.ThreadMemberUpdateEvent;
import discord4j.core.event.domain.thread.ThreadMembersUpdateEvent;
import discord4j.core.object.entity.ThreadMember;
import discord4j.core.object.entity.channel.ThreadChannel;
import discord4j.discordjson.json.ChannelData;
import discord4j.discordjson.json.ThreadMemberData;
import discord4j.discordjson.json.gateway.ThreadCreate;
import discord4j.discordjson.json.gateway.ThreadDelete;
import discord4j.discordjson.json.gateway.ThreadListSync;
import discord4j.discordjson.json.gateway.ThreadMemberUpdate;
import discord4j.discordjson.json.gateway.ThreadMembersUpdate;
import discord4j.discordjson.json.gateway.ThreadUpdate;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

class ThreadDispatchHandlers {
    ThreadDispatchHandlers() {
    }

    static Mono<? extends Event> threadCreate(DispatchContext<ThreadCreate, Void> context) {
        GatewayDiscordClient gateway = context.getGateway();
        ChannelData channel = context.getDispatch().thread();
        return Mono.just(new ThreadChannelCreateEvent(gateway, context.getShardInfo(), new ThreadChannel(gateway, channel)));
    }

    static Mono<? extends Event> threadUpdate(DispatchContext<ThreadUpdate, ChannelData> context) {
        GatewayDiscordClient gateway = context.getGateway();
        ChannelData channel = context.getDispatch().thread();
        Optional<ChannelData> oldData = context.getOldState();
        return Mono.just(new ThreadChannelUpdateEvent(gateway, context.getShardInfo(), new ThreadChannel(gateway, channel), oldData.map(old -> new ThreadChannel(gateway, (ChannelData)old)).orElse(null)));
    }

    static Mono<? extends Event> threadDelete(DispatchContext<ThreadDelete, Void> context) {
        GatewayDiscordClient gateway = context.getGateway();
        ChannelData channel = context.getDispatch().thread();
        return Mono.just(new ThreadChannelDeleteEvent(gateway, context.getShardInfo(), new ThreadChannel(gateway, channel)));
    }

    static Mono<? extends Event> threadListSync(DispatchContext<ThreadListSync, Void> context) {
        GatewayDiscordClient gateway = context.getGateway();
        return Mono.just(new ThreadListSyncEvent(gateway, context.getShardInfo(), context.getDispatch()));
    }

    static Mono<? extends Event> threadMemberUpdate(DispatchContext<ThreadMemberUpdate, ThreadMemberData> context) {
        GatewayDiscordClient gateway = context.getGateway();
        ThreadMemberData member = context.getDispatch().member();
        Optional<ThreadMemberData> oldData = context.getOldState();
        return Mono.just(new ThreadMemberUpdateEvent(gateway, context.getShardInfo(), new ThreadMember(gateway, member), oldData.map(old -> new ThreadMember(gateway, (ThreadMemberData)old)).orElse(null)));
    }

    static Mono<? extends Event> threadMembersUpdate(DispatchContext<ThreadMembersUpdate, List<ThreadMemberData>> context) {
        GatewayDiscordClient gateway = context.getGateway();
        List addedMembers = context.getDispatch().addedMembers().toOptional().orElse(Collections.emptyList());
        Optional<List<ThreadMemberData>> oldData = context.getOldState();
        return Mono.just(new ThreadMembersUpdateEvent(gateway, context.getShardInfo(), context.getDispatch(), addedMembers.stream().map(data -> new ThreadMember(gateway, (ThreadMemberData)data)).collect(Collectors.toList()), oldData.map(list -> list.stream().map(data -> new ThreadMember(gateway, (ThreadMemberData)data)).collect(Collectors.toList())).orElse(null)));
    }
}

