/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.VoiceStateUpdateEvent;
import discord4j.core.object.VoiceState;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.PartialMember;
import discord4j.core.object.entity.StageInstance;
import discord4j.discordjson.json.MemberData;
import discord4j.discordjson.json.VoiceStateData;
import discord4j.gateway.ShardInfo;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class StageRequestToSpeakEvent
extends VoiceStateUpdateEvent {
    private final GatewayDiscordClient gateway;
    private final VoiceStateData voiceStateData;

    public StageRequestToSpeakEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, VoiceState current, @Nullable VoiceState old) {
        super(gateway, shardInfo, current, old);
        this.gateway = gateway;
        this.voiceStateData = current.getData();
    }

    public Mono<Void> acceptRequest() {
        return this.getMember().flatMap(PartialMember::inviteToStageSpeakers);
    }

    public Mono<Void> denyRequest() {
        return this.getMember().flatMap(PartialMember::moveToStageAudience);
    }

    public Mono<StageInstance> getStageInstance() {
        return this.gateway.getStageInstanceByChannelId(Snowflake.of(this.voiceStateData.channelId().get()));
    }

    public Mono<Member> getMember() {
        return this.voiceStateData.member().toOptional().map(data -> Mono.just(new Member(this.gateway, (MemberData)data, this.voiceStateData.guildId().get().asLong()))).orElse(this.gateway.getMemberById(Snowflake.of(this.voiceStateData.guildId().get()), Snowflake.of(this.voiceStateData.userId())));
    }

    @Override
    public String toString() {
        return "StageRequestToSpeakEvent{voiceStateData=" + this.voiceStateData + "} " + super.toString();
    }
}

