/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain.guild;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.guild.GuildEvent;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Member;
import discord4j.gateway.ShardInfo;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class MemberChunkEvent
extends GuildEvent {
    private final long guildId;
    private final Set<Member> members;
    private final int chunkIndex;
    private final int chunkCount;
    private final List<Snowflake> notFound;
    @Nullable
    private final String nonce;

    public MemberChunkEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, long guildId, Set<Member> members, int chunkIndex, int chunkCount, List<Snowflake> notFound, @Nullable String nonce) {
        super(gateway, shardInfo);
        this.guildId = guildId;
        this.members = members;
        this.chunkIndex = chunkIndex;
        this.chunkCount = chunkCount;
        this.notFound = notFound;
        this.nonce = nonce;
    }

    public Snowflake getGuildId() {
        return Snowflake.of(this.guildId);
    }

    public Mono<Guild> getGuild() {
        return this.getClient().getGuildById(this.getGuildId());
    }

    public Set<Member> getMembers() {
        return this.members;
    }

    public int getChunkIndex() {
        return this.chunkIndex;
    }

    public int getChunkCount() {
        return this.chunkCount;
    }

    public List<Snowflake> getNotFound() {
        return this.notFound;
    }

    public Optional<String> getNonce() {
        return Optional.ofNullable(this.nonce);
    }

    public String toString() {
        return "MemberChunkEvent{guildId=" + this.guildId + ", members=" + this.members + ", chunkIndex=" + this.chunkIndex + ", chunkCount=" + this.chunkCount + ", notFound=" + this.notFound + ", nonce='" + this.nonce + '\'' + '}';
    }
}

