/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity.channel;

import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.rest.util.PermissionSet;
import reactor.core.publisher.Mono;

public interface GuildChannel
extends Channel {
    default public Snowflake getGuildId() {
        return this.getData().guildId().toOptional().map(Snowflake::of).orElseThrow(IllegalStateException::new);
    }

    default public Mono<Guild> getGuild() {
        return this.getClient().getGuildById(this.getGuildId());
    }

    default public Mono<Guild> getGuild(EntityRetrievalStrategy retrievalStrategy) {
        return this.getClient().withRetrievalStrategy(retrievalStrategy).getGuildById(this.getGuildId());
    }

    public Mono<PermissionSet> getEffectivePermissions(Snowflake var1);

    public Mono<PermissionSet> getEffectivePermissions(Member var1);

    default public String getName() {
        return this.getData().name().toOptional().orElseThrow(IllegalStateException::new);
    }
}

