/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity.channel;

import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.channel.GuildChannel;
import discord4j.core.object.entity.channel.MessageChannel;
import discord4j.discordjson.json.BulkDeleteRequest;
import discord4j.rest.util.Permission;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface GuildMessageChannel
extends GuildChannel,
MessageChannel {
    default public Flux<Snowflake> bulkDelete(Publisher<Snowflake> messageIds) {
        return this.getRestChannel().bulkDelete(messageIds);
    }

    default public Flux<Message> bulkDeleteMessages(Publisher<Message> messages) {
        Instant timeLimit = Instant.now().minus(Duration.ofDays(14L));
        return Flux.from(messages).distinct(Message::getId).buffer(100).flatMap(allMessages -> {
            ArrayList<Message> eligibleMessages = new ArrayList<Message>(0);
            ArrayList<Message> ineligibleMessages = new ArrayList<Message>(0);
            for (Message message : allMessages) {
                if (message.getId().getTimestamp().isBefore(timeLimit)) {
                    ineligibleMessages.add(message);
                    continue;
                }
                eligibleMessages.add(message);
            }
            if (eligibleMessages.size() == 1) {
                ineligibleMessages.add((Message)eligibleMessages.get(0));
                eligibleMessages.clear();
            }
            Collection eligibleIds = eligibleMessages.stream().map(Message::getId).map(Snowflake::asString).collect(Collectors.toList());
            return Mono.just(eligibleIds).filter(chunk -> !chunk.isEmpty()).flatMap(chunk -> this.getClient().getRestClient().getChannelService().bulkDeleteMessages(this.getId().asLong(), BulkDeleteRequest.builder().messages((Iterable<String>)chunk).build())).thenMany(Flux.fromIterable(ineligibleMessages));
        });
    }

    default public Flux<Member> getMembers() {
        return this.getGuild().flatMapMany(Guild::getMembers).filterWhen(member -> this.getEffectivePermissions(member.getId()).map(permissions -> permissions.contains((Object)Permission.VIEW_CHANNEL)));
    }
}

