/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity.channel;

import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.MessageCreateMono;
import discord4j.core.spec.MessageCreateSpec;
import discord4j.core.spec.legacy.LegacyEmbedCreateSpec;
import discord4j.core.spec.legacy.LegacyMessageCreateSpec;
import discord4j.discordjson.json.MessageCreateRequest;
import discord4j.discordjson.json.MessageData;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.MultipartRequest;
import discord4j.rest.util.PaginationUtil;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;

public interface MessageChannel
extends Channel {
    default public Optional<Snowflake> getLastMessageId() {
        return Possible.flatOpt(this.getData().lastMessageId()).map(Snowflake::of);
    }

    default public Mono<Message> getLastMessage() {
        return Mono.justOrEmpty(this.getLastMessageId()).flatMap(id -> this.getClient().getMessageById(this.getId(), (Snowflake)id));
    }

    default public Mono<Message> getLastMessage(EntityRetrievalStrategy retrievalStrategy) {
        return Mono.justOrEmpty(this.getLastMessageId()).flatMap(id -> this.getClient().withRetrievalStrategy(retrievalStrategy).getMessageById(this.getId(), (Snowflake)id));
    }

    default public Optional<Instant> getLastPinTimestamp() {
        return Possible.flatOpt(this.getData().lastPinTimestamp()).map(timestamp -> DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)timestamp, Instant::from));
    }

    @Deprecated
    default public Mono<Message> createMessage(Consumer<? super LegacyMessageCreateSpec> spec) {
        return Mono.defer(() -> {
            LegacyMessageCreateSpec mutatedSpec = new LegacyMessageCreateSpec();
            this.getClient().getRestClient().getRestResources().getAllowedMentions().ifPresent(mutatedSpec::setAllowedMentions);
            spec.accept(mutatedSpec);
            return this.getRestChannel().createMessage((MultipartRequest<MessageCreateRequest>)mutatedSpec.asRequest());
        }).map(data -> new Message(this.getClient(), (MessageData)data));
    }

    default public Mono<Message> createMessage(MessageCreateSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> {
            MessageCreateSpec actualSpec = this.getClient().getRestClient().getRestResources().getAllowedMentions().filter(allowedMentions -> !spec.isAllowedMentionsPresent()).map(spec::withAllowedMentions).orElse(spec);
            return this.getRestChannel().createMessage((MultipartRequest<MessageCreateRequest>)actualSpec.asRequest());
        }).map(data -> new Message(this.getClient(), (MessageData)data));
    }

    default public MessageCreateMono createMessage(String message) {
        return MessageCreateMono.of(this).withContent(message);
    }

    default public MessageCreateMono createMessage(EmbedCreateSpec ... embeds) {
        return MessageCreateMono.of(this).withEmbeds(embeds);
    }

    @Deprecated
    default public Mono<Message> createEmbed(Consumer<? super LegacyEmbedCreateSpec> spec) {
        return this.createMessage((? super LegacyMessageCreateSpec messageSpec) -> messageSpec.setEmbed(spec));
    }

    @Deprecated
    default public MessageCreateMono createEmbed(EmbedCreateSpec embed) {
        return MessageCreateMono.of(this).withEmbeds(embed);
    }

    default public Mono<Void> type() {
        return this.getClient().getRestClient().getChannelService().triggerTypingIndicator(this.getId().asLong()).then();
    }

    default public Flux<Long> typeUntil(Publisher<?> until) {
        Scheduler delayScheduler = this.getClient().getCoreResources().getReactorResources().getTimerTaskScheduler();
        Flux repeatUntilOther = Flux.interval(Duration.ofSeconds(8L), delayScheduler).flatMap(tick -> this.type().thenReturn(tick + 1L)).takeUntilOther(until);
        return this.type().thenReturn(0L).concatWith(repeatUntilOther);
    }

    default public Flux<Message> getMessagesBefore(Snowflake messageId) {
        Function doRequest = params -> this.getClient().getRestClient().getChannelService().getMessages(this.getId().asLong(), (Map<String, Object>)params);
        return PaginationUtil.paginateBefore(doRequest, data -> Snowflake.asLong(data.id()), messageId.asLong(), 100).map(data -> new Message(this.getClient(), (MessageData)data));
    }

    default public Flux<Message> getMessagesAfter(Snowflake messageId) {
        Function doRequest = params -> this.getClient().getRestClient().getChannelService().getMessages(this.getId().asLong(), (Map<String, Object>)params);
        return PaginationUtil.paginateAfter(doRequest, data -> Snowflake.asLong(data.id()), messageId.asLong(), 100).map(data -> new Message(this.getClient(), (MessageData)data));
    }

    default public Mono<Message> getMessageById(Snowflake id) {
        return this.getClient().getMessageById(this.getId(), id);
    }

    default public Mono<Message> getMessageById(Snowflake id, EntityRetrievalStrategy retrievalStrategy) {
        return this.getClient().withRetrievalStrategy(retrievalStrategy).getMessageById(this.getId(), id);
    }

    default public Flux<Message> getPinnedMessages() {
        return this.getClient().getRestClient().getChannelService().getPinnedMessages(this.getId().asLong()).map(data -> new Message(this.getClient(), (MessageData)data));
    }
}

