/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.reaction;

import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.GuildEmoji;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.ReactionData;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import reactor.util.annotation.Nullable;

public abstract class ReactionEmoji {
    public static Custom custom(GuildEmoji emoji) {
        return new Custom(emoji.getId().asLong(), emoji.getName(), emoji.isAnimated());
    }

    public static Custom custom(Snowflake id, String name, boolean isAnimated) {
        return new Custom(id.asLong(), name, isAnimated);
    }

    public static Unicode unicode(String raw) {
        return new Unicode(raw);
    }

    public static Unicode codepoints(String ... codepoints) {
        String combined = Arrays.stream(codepoints).map(c -> Integer.parseInt(c.substring(2), 16)).reduce(new StringBuilder(), StringBuilder::appendCodePoint, StringBuilder::append).toString();
        return ReactionEmoji.unicode(combined);
    }

    public static ReactionEmoji of(@Nullable Long id, String name, boolean isAnimated) {
        return id == null ? ReactionEmoji.unicode(name) : ReactionEmoji.custom(Snowflake.of(id), name, isAnimated);
    }

    public static ReactionEmoji of(ReactionData data) {
        return ReactionEmoji.of(data.emoji());
    }

    public static ReactionEmoji of(EmojiData data) {
        if (data.id().isPresent()) {
            return ReactionEmoji.custom(Snowflake.of(data.id().get()), data.name().orElseThrow(IllegalArgumentException::new), data.animated().toOptional().orElse(false));
        }
        return ReactionEmoji.unicode(data.name().orElseThrow(IllegalArgumentException::new));
    }

    public abstract String asFormat();

    public Optional<Custom> asCustomEmoji() {
        return this instanceof Custom ? Optional.of((Custom)this) : Optional.empty();
    }

    public Optional<Unicode> asUnicodeEmoji() {
        return this instanceof Unicode ? Optional.of((Unicode)this) : Optional.empty();
    }

    public abstract EmojiData asEmojiData();

    public static final class Custom
    extends ReactionEmoji {
        private final long id;
        private final String name;
        private final boolean isAnimated;

        private Custom(long id, String name, boolean isAnimated) {
            this.id = id;
            this.name = name;
            this.isAnimated = isAnimated;
        }

        public Snowflake getId() {
            return Snowflake.of(this.id);
        }

        public String getName() {
            return this.name;
        }

        public boolean isAnimated() {
            return this.isAnimated;
        }

        @Override
        public EmojiData asEmojiData() {
            return EmojiData.builder().id(this.id).name(this.name).animated(this.isAnimated).build();
        }

        @Override
        public String asFormat() {
            return Custom.asFormat(this.isAnimated(), this.getName(), this.getId());
        }

        public static String asFormat(boolean isAnimated, String name, Snowflake id) {
            return '<' + (isAnimated ? "a" : "") + ':' + Objects.requireNonNull(name) + ':' + Objects.requireNonNull(id).asString() + '>';
        }

        public String toString() {
            return "ReactionEmoji.Custom{id=" + this.id + ", name='" + this.name + '\'' + ", isAnimated=" + this.isAnimated + "} " + super.toString();
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Custom custom = (Custom)o;
            return this.id == custom.id;
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }

    public static final class Unicode
    extends ReactionEmoji {
        private final String raw;

        private Unicode(String raw) {
            this.raw = raw;
        }

        public String getRaw() {
            return this.raw;
        }

        @Override
        public EmojiData asEmojiData() {
            return EmojiData.builder().name(this.raw).build();
        }

        @Override
        public String asFormat() {
            return this.getRaw();
        }

        public String toString() {
            return "ReactionEmoji.Unicode{raw='" + this.raw + '\'' + "} " + super.toString();
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Unicode unicode = (Unicode)o;
            return Objects.equals(this.raw, unicode.raw);
        }

        public int hashCode() {
            return this.raw.hashCode();
        }
    }
}

